/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.admin.patch.impl;

import org.alfresco.i18n.I18NUtil;
import org.alfresco.repo.admin.patch.AbstractPatch;
import org.alfresco.repo.importer.ImporterBootstrap;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.PermissionService;

public class SpacesRootPermissionPatch
extends AbstractPatch {
    private static final String MSG_SUCCESS = "patch.spacesRootPermission.result";
    private ImporterBootstrap spacesBootstrap;
    private NodeService nodeService;
    private PermissionService permissionService;

    public void setSpacesBootstrap(ImporterBootstrap spacesBootstrap) {
        this.spacesBootstrap = spacesBootstrap;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    protected String applyInternal() throws Exception {
        NodeRef rootNodeRef = this.nodeService.getRootNode(this.spacesBootstrap.getStoreRef());
        this.permissionService.deletePermission(rootNodeRef, "GROUP_EVERYONE", "Consumer");
        this.permissionService.setPermission(rootNodeRef, "GROUP_EVERYONE", "Read", true);
        return I18NUtil.getMessage((String)MSG_SUCCESS);
    }
}

