/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.admin.patch.impl;

import java.util.List;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.i18n.I18NUtil;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.admin.patch.AbstractPatch;
import org.alfresco.repo.security.authority.AuthorityDAOImpl;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.RegexQNamePattern;

public class TopLevelGroupParentChildAssociationTypePatch
extends AbstractPatch {
    private static final String MSG_RESULT = "patch.topLevelGroupParentChildAssociationTypePatch.result";

    protected String applyInternal() throws Exception {
        NodeRef nodeRef = this.getAuthorityContainer();
        List<ChildAssociationRef> results = this.nodeService.getChildAssocs(nodeRef);
        for (ChildAssociationRef car : results) {
            if (car.getTypeQName().equals(ContentModel.ASSOC_CHILDREN)) continue;
            this.nodeService.moveNode(car.getChildRef(), car.getParentRef(), ContentModel.ASSOC_CHILDREN, car.getQName());
        }
        return I18NUtil.getMessage((String)MSG_RESULT);
    }

    private NodeRef getAuthorityContainer() {
        QName qnameAssocSystem = QName.createQName("sys", "system", this.namespaceService);
        QName qnameAssocAuthorities = QName.createQName("sys", "authorities", this.namespaceService);
        NodeRef rootNodeRef = this.nodeService.getRootNode(AuthorityDAOImpl.STOREREF_USERS);
        List<ChildAssociationRef> results = this.nodeService.getChildAssocs(rootNodeRef, RegexQNamePattern.MATCH_ALL, qnameAssocSystem);
        NodeRef sysNodeRef = null;
        if (results.size() == 0) {
            throw new AlfrescoRuntimeException("Required authority system path not found: " + qnameAssocSystem);
        }
        sysNodeRef = results.get(0).getChildRef();
        results = this.nodeService.getChildAssocs(sysNodeRef, RegexQNamePattern.MATCH_ALL, qnameAssocAuthorities);
        NodeRef authNodeRef = null;
        if (results.size() == 0) {
            throw new AlfrescoRuntimeException("Required authority path not found: " + qnameAssocAuthorities);
        }
        authNodeRef = results.get(0).getChildRef();
        return authNodeRef;
    }
}

