/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.audit;

import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.policy.PolicyScope;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.security.AuthenticationService;
import org.alfresco.service.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AuditableAspect {
    private static final Log logger = LogFactory.getLog(AuditableAspect.class);
    private static final String USERNAME_UNKNOWN = "unknown";
    private NodeService nodeService;
    private AuthenticationService authenticationService;
    private PolicyComponent policyComponent;
    private Behaviour onCreateAudit;
    private Behaviour onAddAudit;
    private Behaviour onUpdateAudit;

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setPolicyComponent(PolicyComponent policyComponent) {
        this.policyComponent = policyComponent;
    }

    public void setAuthenticationService(AuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
    }

    public void init() {
        this.onCreateAudit = new JavaBehaviour(this, "onCreateAudit", Behaviour.NotificationFrequency.FIRST_EVENT);
        this.onAddAudit = new JavaBehaviour(this, "onAddAudit", Behaviour.NotificationFrequency.FIRST_EVENT);
        this.onUpdateAudit = new JavaBehaviour(this, "onUpdateAudit", Behaviour.NotificationFrequency.TRANSACTION_COMMIT);
        this.policyComponent.bindClassBehaviour(QName.createQName("http://www.alfresco.org", "onCreateNode"), ContentModel.ASPECT_AUDITABLE, this.onCreateAudit);
        this.policyComponent.bindClassBehaviour(QName.createQName("http://www.alfresco.org", "onAddAspect"), ContentModel.ASPECT_AUDITABLE, this.onAddAudit);
        this.policyComponent.bindClassBehaviour(QName.createQName("http://www.alfresco.org", "onUpdateNode"), ContentModel.ASPECT_AUDITABLE, this.onUpdateAudit);
        this.policyComponent.bindClassBehaviour(QName.createQName("http://www.alfresco.org", "onCopyNode"), ContentModel.ASPECT_AUDITABLE, (Behaviour)new JavaBehaviour(this, "onCopy"));
    }

    public void onCreateAudit(ChildAssociationRef childAssocRef) {
        NodeRef nodeRef = childAssocRef.getChildRef();
        this.onAddAudit(nodeRef, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onAddAudit(NodeRef nodeRef, QName aspect) {
        Map<QName, Serializable> properties = this.nodeService.getProperties(nodeRef);
        Date now = new Date(System.currentTimeMillis());
        properties.put(ContentModel.PROP_CREATED, now);
        properties.put(ContentModel.PROP_MODIFIED, now);
        String creator = (String)((Object)properties.get(ContentModel.PROP_CREATOR));
        if (creator == null || creator.length() == 0) {
            creator = this.getUsername();
            properties.put(ContentModel.PROP_CREATOR, (Serializable)((Object)creator));
        }
        properties.put(ContentModel.PROP_MODIFIER, (Serializable)((Object)creator));
        try {
            this.onUpdateAudit.disable();
            AuthenticationUtil.runAs(new SetAuditProperties(this.nodeService, nodeRef, properties), AuthenticationUtil.getSystemUserName());
        }
        finally {
            this.onUpdateAudit.enable();
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Auditable node " + nodeRef + " created [created,modified=" + now + ";creator,modifier=" + creator + "]"));
        }
    }

    public void onUpdateAudit(NodeRef nodeRef) {
        block3: {
            try {
                Map<QName, Serializable> properties = this.nodeService.getProperties(nodeRef);
                Date now = new Date(System.currentTimeMillis());
                properties.put(ContentModel.PROP_MODIFIED, now);
                String modifier = this.getUsername();
                properties.put(ContentModel.PROP_MODIFIER, (Serializable)((Object)modifier));
                AuthenticationUtil.runAs(new SetAuditProperties(this.nodeService, nodeRef, properties), AuthenticationUtil.getSystemUserName());
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Auditable node " + nodeRef + " updated [modified=" + now + ";modifier=" + modifier + "]"));
                }
            }
            catch (InvalidNodeRefException e) {
                if (!logger.isDebugEnabled()) break block3;
                logger.debug((Object)("Warning: Auditable node " + nodeRef + " no longer exists - cannot update"));
            }
        }
    }

    private String getUsername() {
        String currentUserName = this.authenticationService.getCurrentUserName();
        if (currentUserName != null) {
            return currentUserName;
        }
        return USERNAME_UNKNOWN;
    }

    public void onCopy(QName sourceClassRef, NodeRef sourceNodeRef, StoreRef destinationStoreRef, boolean copyToNewNode, PolicyScope copyDetails) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SetAuditProperties
    implements AuthenticationUtil.RunAsWork<Boolean> {
        private NodeService nodeService;
        private NodeRef nodeRef;
        private Map<QName, Serializable> properties;

        private SetAuditProperties(NodeService nodeService, NodeRef nodeRef, Map<QName, Serializable> properties) {
            this.nodeService = nodeService;
            this.nodeRef = nodeRef;
            this.properties = properties;
        }

        @Override
        public Boolean doWork() throws Exception {
            this.nodeService.setProperties(this.nodeRef, this.properties);
            return Boolean.TRUE;
        }
    }
}

