/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.audit;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.BaseSpringTest;
import org.alfresco.util.debug.NodeStoreInspector;

public class AuditableAspectTest
extends BaseSpringTest {
    private NodeService nodeService;
    private StoreRef storeRef;
    private NodeRef rootNodeRef;

    protected void onSetUpInTransaction() throws Exception {
        this.nodeService = (NodeService)this.applicationContext.getBean("dbNodeService");
        this.storeRef = this.nodeService.createStore("workspace", "Test_" + System.currentTimeMillis());
        this.rootNodeRef = this.nodeService.getRootNode(this.storeRef);
    }

    public void testAudit() {
        ChildAssociationRef childAssocRef = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName("{test}testfolder"), ContentModel.TYPE_FOLDER);
        this.assertAuditableProperties(childAssocRef.getChildRef());
        System.out.println(NodeStoreInspector.dumpNodeStore(this.nodeService, this.storeRef));
    }

    public void testNoAudit() {
        HashMap<QName, Serializable> personProps = new HashMap<QName, Serializable>();
        personProps.put(ContentModel.PROP_USERNAME, (Serializable)((Object)"test person"));
        personProps.put(ContentModel.PROP_HOMEFOLDER, this.rootNodeRef);
        personProps.put(ContentModel.PROP_FIRSTNAME, (Serializable)((Object)"test first name"));
        personProps.put(ContentModel.PROP_LASTNAME, (Serializable)((Object)"test last name"));
        ChildAssociationRef childAssocRef = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName("{test}testperson"), ContentModel.TYPE_PERSON, personProps);
        Set<QName> aspects = this.nodeService.getAspects(childAssocRef.getChildRef());
        AuditableAspectTest.assertFalse((boolean)aspects.contains(ContentModel.ASPECT_AUDITABLE));
        System.out.println(NodeStoreInspector.dumpNodeStore(this.nodeService, this.storeRef));
    }

    public void testAddAudit() {
        HashMap<QName, Serializable> personProps = new HashMap<QName, Serializable>();
        personProps.put(ContentModel.PROP_USERNAME, (Serializable)((Object)"test person"));
        personProps.put(ContentModel.PROP_HOMEFOLDER, this.rootNodeRef);
        personProps.put(ContentModel.PROP_FIRSTNAME, (Serializable)((Object)"test first name"));
        personProps.put(ContentModel.PROP_LASTNAME, (Serializable)((Object)"test last name"));
        ChildAssociationRef childAssocRef = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName("{test}testperson"), ContentModel.TYPE_PERSON, personProps);
        Set<QName> aspects = this.nodeService.getAspects(childAssocRef.getChildRef());
        AuditableAspectTest.assertFalse((boolean)aspects.contains(ContentModel.ASPECT_AUDITABLE));
        this.nodeService.addAspect(childAssocRef.getChildRef(), ContentModel.ASPECT_AUDITABLE, null);
        this.nodeService.addAspect(childAssocRef.getChildRef(), ContentModel.ASPECT_TITLED, null);
        aspects = this.nodeService.getAspects(childAssocRef.getChildRef());
        AuditableAspectTest.assertTrue((boolean)aspects.contains(ContentModel.ASPECT_AUDITABLE));
        this.assertAuditableProperties(childAssocRef.getChildRef());
        System.out.println(NodeStoreInspector.dumpNodeStore(this.nodeService, this.storeRef));
    }

    public void testAddAspect() {
        HashMap<QName, Serializable> personProps = new HashMap<QName, Serializable>();
        personProps.put(ContentModel.PROP_USERNAME, (Serializable)((Object)"test person"));
        personProps.put(ContentModel.PROP_HOMEFOLDER, this.rootNodeRef);
        personProps.put(ContentModel.PROP_FIRSTNAME, (Serializable)((Object)"test first name "));
        personProps.put(ContentModel.PROP_LASTNAME, (Serializable)((Object)"test last name"));
        ChildAssociationRef childAssocRef = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName("{test}testperson"), ContentModel.TYPE_PERSON, personProps);
        this.nodeService.addAspect(childAssocRef.getChildRef(), ContentModel.ASPECT_TITLED, null);
        System.out.println(NodeStoreInspector.dumpNodeStore(this.nodeService, this.storeRef));
    }

    private void assertAuditableProperties(NodeRef nodeRef) {
        Map<QName, Serializable> props = this.nodeService.getProperties(nodeRef);
        AuditableAspectTest.assertNotNull((Object)props.get(ContentModel.PROP_CREATED));
        AuditableAspectTest.assertNotNull((Object)props.get(ContentModel.PROP_MODIFIED));
        AuditableAspectTest.assertNotNull((Object)props.get(ContentModel.PROP_CREATOR));
        AuditableAspectTest.assertNotNull((Object)props.get(ContentModel.PROP_MODIFIER));
    }
}

