/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.cache;

import java.io.Serializable;
import javax.transaction.UserTransaction;
import junit.framework.TestCase;
import net.sf.ehcache.CacheManager;
import org.alfresco.repo.cache.SimpleCache;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheTest
extends TestCase {
    private static ApplicationContext ctx = new ClassPathXmlApplicationContext(new String[]{"classpath:cache-test-context.xml", ApplicationContextHelper.CONFIG_LOCATIONS[0]});
    private ServiceRegistry serviceRegistry;
    private SimpleCache<String, Serializable> standaloneCache;
    private SimpleCache<String, Serializable> backingCache;
    private SimpleCache<String, Serializable> transactionalCache;

    public void setUp() throws Exception {
        this.serviceRegistry = (ServiceRegistry)ctx.getBean("ServiceRegistry");
        this.standaloneCache = (SimpleCache)ctx.getBean("ehCache1");
        this.backingCache = (SimpleCache)ctx.getBean("backingCache");
        this.transactionalCache = (SimpleCache)ctx.getBean("transactionalCache");
    }

    public void tearDown() {
        this.serviceRegistry = null;
        this.standaloneCache = null;
        this.backingCache = null;
        this.transactionalCache = null;
    }

    public void testSetUp() throws Exception {
        CacheManager cacheManager = (CacheManager)ctx.getBean("ehCacheManager");
        CacheTest.assertNotNull((Object)cacheManager);
        CacheManager cacheManagerCheck = (CacheManager)ctx.getBean("ehCacheManager");
        CacheTest.assertTrue((cacheManager == cacheManagerCheck ? 1 : 0) != 0);
        CacheTest.assertNotNull((Object)this.serviceRegistry);
        CacheTest.assertNotNull(this.backingCache);
        CacheTest.assertNotNull(this.standaloneCache);
        CacheTest.assertNotNull(this.transactionalCache);
    }

    public void testEhcacheAdaptors() throws Exception {
        this.backingCache.put("A", (Serializable)((Object)"AAA"));
        CacheTest.assertNull((String)"Second cache should not have first's present", (Object)this.standaloneCache.get("A"));
        CacheTest.assertEquals((Object)"AAA", (Object)this.backingCache.get("A"));
        this.backingCache.remove("A");
        CacheTest.assertNull((Object)this.backingCache.get("A"));
    }

    public void testTransactionalCacheNoTxn() throws Exception {
        String key = "B";
        String value = "BBB";
        this.transactionalCache.put(key, (Serializable)((Object)value));
        CacheTest.assertEquals((String)"Backing cache not used for put when no transaction present", (Object)value, (Object)this.backingCache.get(key));
        this.backingCache.remove(key);
        CacheTest.assertNull((String)"Backing cache not used for removed when no transaction present", (Object)this.transactionalCache.get(key));
        this.backingCache.put(key, (Serializable)((Object)value));
        this.transactionalCache.remove(key);
        CacheTest.assertNull((String)"Non-transactional remove didn't go to backing cache", (Object)this.backingCache.get(key));
    }

    public void testTransactionalCacheWithTxn() throws Throwable {
        String newGlobalOne = "new_global_one";
        String newGlobalTwo = "new_global_two";
        String newGlobalThree = "new_global_three";
        String updatedTxnThree = "updated_txn_three";
        this.backingCache.put(newGlobalOne, (Serializable)((Object)newGlobalOne));
        this.backingCache.put(newGlobalTwo, (Serializable)((Object)newGlobalTwo));
        this.backingCache.put(newGlobalThree, (Serializable)((Object)newGlobalThree));
        TransactionService transactionService = this.serviceRegistry.getTransactionService();
        UserTransaction txn = transactionService.getUserTransaction();
        try {
            txn.begin();
            this.transactionalCache.remove(newGlobalOne);
            CacheTest.assertFalse((String)"Item was not removed from txn cache", (boolean)this.transactionalCache.contains(newGlobalOne));
            CacheTest.assertNull((String)"Get didn't return null", (Object)this.transactionalCache.get(newGlobalOne));
            CacheTest.assertTrue((String)"Item was removed from backing cache", (boolean)this.backingCache.contains(newGlobalOne));
            this.transactionalCache.put(updatedTxnThree, (Serializable)((Object)"XXX"));
            CacheTest.assertEquals((String)"Item not updated in txn cache", (Object)"XXX", (Object)this.transactionalCache.get(updatedTxnThree));
            CacheTest.assertFalse((String)"Item was put into backing cache", (boolean)this.backingCache.contains(updatedTxnThree));
            txn.commit();
            CacheTest.assertFalse((String)"Item was not removed from backing cache", (boolean)this.backingCache.contains(newGlobalOne));
            CacheTest.assertNull((String)"Item could still be fetched from backing cache", (Object)this.backingCache.get(newGlobalOne));
            CacheTest.assertEquals((String)"Item not updated in backing cache", (Object)"XXX", (Object)this.backingCache.get(updatedTxnThree));
        }
        catch (Throwable e) {
            if (txn.getStatus() == 0) {
                txn.rollback();
            }
            throw e;
        }
    }

    public long runPerformanceTestOnCache(SimpleCache<String, Serializable> cache, int objectCount) {
        for (int i = 0; i < objectCount; ++i) {
            String key = Integer.toString(i);
            Integer value = new Integer(i);
            cache.put(key, value);
        }
        long start = System.nanoTime();
        for (int i = 0; i < objectCount; ++i) {
            String key = Integer.toString(i);
            cache.remove(key);
            key = Integer.toString(i + objectCount);
            Integer value = new Integer(i + objectCount);
            cache.put(key, value);
        }
        long stop = System.nanoTime();
        return stop - start;
    }

    public void testPerformance() throws Exception {
        for (int i = 0; i < 5; ++i) {
            int count = (int)Math.pow(10.0, i);
            long timePlain = this.runPerformanceTestOnCache(this.standaloneCache, count);
            TransactionService transactionService = this.serviceRegistry.getTransactionService();
            UserTransaction txn = transactionService.getUserTransaction();
            txn.begin();
            long timeTxn = this.runPerformanceTestOnCache(this.transactionalCache, count);
            long commitStart = System.nanoTime();
            txn.commit();
            long commitEnd = System.nanoTime();
            long commitTime = commitEnd - commitStart;
            System.out.println("Cache performance test: \n   count: " + count + "\n" + "   direct: " + timePlain / (long)count + " ns\\count \n" + "   transaction: " + (timeTxn += commitTime) / (long)count + " ns\\count");
        }
    }
}

