/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.cache;

import java.io.IOException;
import java.io.Serializable;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Element;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.cache.SimpleCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EhCacheAdapter<K extends Serializable, V extends Serializable>
implements SimpleCache<K, V> {
    private Cache cache;

    public void setCache(Cache cache) {
        this.cache = cache;
    }

    @Override
    public boolean contains(K key) {
        try {
            return this.cache.get(key) != null;
        }
        catch (CacheException e) {
            throw new AlfrescoRuntimeException("contains failed", (Throwable)e);
        }
    }

    @Override
    public V get(K key) {
        try {
            Element element = this.cache.get(key);
            if (element != null) {
                return (V)element.getValue();
            }
            return null;
        }
        catch (CacheException e) {
            throw new AlfrescoRuntimeException("Failed to get from EhCache: \n   key: " + key);
        }
    }

    @Override
    public void put(K key, V value) {
        Element element = new Element(key, value);
        this.cache.put(element);
    }

    @Override
    public void remove(K key) {
        this.cache.remove(key);
    }

    @Override
    public void clear() {
        try {
            this.cache.removeAll();
        }
        catch (IOException e) {
            throw new AlfrescoRuntimeException("Failed to clear cache", (Throwable)e);
        }
    }
}

