/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.cache;

import java.io.FileNotFoundException;
import java.net.URL;
import java.util.Properties;
import net.sf.ehcache.CacheManager;
import org.alfresco.error.AlfrescoRuntimeException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.cache.Cache;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.CacheProvider;
import org.hibernate.cache.EhCacheProvider;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.util.ResourceUtils;

public class InternalEhCacheManagerFactoryBean
implements FactoryBean,
CacheProvider {
    public static final String CUSTOM_CONFIGURATION_FILE = "classpath:alfresco/extension/ehcache-custom.xml";
    public static final String DEFAULT_CONFIGURATION_FILE = "classpath:alfresco/ehcache-default.xml";
    private static Log logger = LogFactory.getLog(InternalEhCacheManagerFactoryBean.class);
    private static boolean initialized;
    private static EhCacheProvider hibernateEhCacheProvider;

    private static synchronized void initCacheManager() {
        if (initialized) {
            return;
        }
        try {
            boolean defaultLocation = false;
            try {
                URL configUrl = ResourceUtils.getURL((String)CUSTOM_CONFIGURATION_FILE);
                CacheManager.create((URL)configUrl);
            }
            catch (FileNotFoundException e) {
                URL configUrl = ResourceUtils.getURL((String)DEFAULT_CONFIGURATION_FILE);
                CacheManager.create((URL)configUrl);
                defaultLocation = true;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Created EHCache CacheManager instance: \n   configuration: " + (defaultLocation ? DEFAULT_CONFIGURATION_FILE : CUSTOM_CONFIGURATION_FILE)));
            }
            initialized = true;
        }
        catch (Throwable e) {
            throw new AlfrescoRuntimeException("EHCache configuration failed", e);
        }
    }

    public static CacheManager getInstance() {
        InternalEhCacheManagerFactoryBean.initCacheManager();
        return CacheManager.getInstance();
    }

    public Cache buildCache(String regionName, Properties properties) throws CacheException {
        InternalEhCacheManagerFactoryBean.initCacheManager();
        return hibernateEhCacheProvider.buildCache(regionName, properties);
    }

    public boolean isMinimalPutsEnabledByDefault() {
        return hibernateEhCacheProvider.isMinimalPutsEnabledByDefault();
    }

    public long nextTimestamp() {
        return hibernateEhCacheProvider.nextTimestamp();
    }

    public void start(Properties properties) throws CacheException {
        InternalEhCacheManagerFactoryBean.initCacheManager();
        hibernateEhCacheProvider.start(properties);
    }

    public void stop() {
        InternalEhCacheManagerFactoryBean.initCacheManager();
        hibernateEhCacheProvider.stop();
    }

    public Object getObject() throws Exception {
        InternalEhCacheManagerFactoryBean.initCacheManager();
        return CacheManager.getInstance();
    }

    public Class getObjectType() {
        return CacheManager.class;
    }

    public boolean isSingleton() {
        return true;
    }

    static {
        hibernateEhCacheProvider = new EhCacheProvider();
    }
}

