/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.cache;

import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.cache.SimpleCache;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.repo.transaction.TransactionListener;
import org.alfresco.util.EqualsHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransactionalCache<K extends Serializable, V extends Serializable>
implements SimpleCache<K, V>,
TransactionListener,
InitializingBean {
    private static final String RESOURCE_KEY_TXN_DATA = "TransactionalCache.TxnData";
    private static final String VALUE_DELETE = "TransactionalCache.DeleteMarker";
    private static Log logger = LogFactory.getLog(TransactionalCache.class);
    private String name;
    private SimpleCache<Serializable, Serializable> sharedCache;
    private CacheManager cacheManager;
    private int maxCacheSize = 500;
    private String resourceKeyTxnData;

    public String toString() {
        return this.name;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransactionalCache)) {
            return false;
        }
        TransactionalCache that = (TransactionalCache)obj;
        return EqualsHelper.nullSafeEquals((Object)this.name, (Object)that.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public void setSharedCache(SimpleCache<Serializable, Serializable> sharedCache) {
        this.sharedCache = sharedCache;
    }

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public void setMaxCacheSize(int maxCacheSize) {
        this.maxCacheSize = maxCacheSize;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.name, (String)"name property not set");
        Assert.notNull((Object)this.cacheManager, (String)"cacheManager property not set");
        this.resourceKeyTxnData = "TransactionalCache.TxnData." + this.name;
    }

    private TransactionData getTransactionData() {
        TransactionData data = (TransactionData)AlfrescoTransactionSupport.getResource(this.resourceKeyTxnData);
        if (data == null) {
            String txnId = AlfrescoTransactionSupport.getTransactionId();
            data = new TransactionData();
            data.updatedItemsCache = new Cache(this.name + "_" + txnId + "_updates", this.maxCacheSize, false, true, 0L, 0L);
            data.removedItemsCache = new Cache(this.name + "_" + txnId + "_removes", this.maxCacheSize, false, true, 0L, 0L);
            try {
                this.cacheManager.addCache(data.updatedItemsCache);
                this.cacheManager.addCache(data.removedItemsCache);
            }
            catch (CacheException e) {
                throw new AlfrescoRuntimeException("Failed to add txn caches to manager", (Throwable)e);
            }
            finally {
                AlfrescoTransactionSupport.bindListener(this);
            }
            AlfrescoTransactionSupport.bindResource(this.resourceKeyTxnData, data);
        }
        return data;
    }

    @Override
    public boolean contains(K key) {
        V value = this.get(key);
        return value != null;
    }

    @Override
    public V get(K key) {
        boolean ignoreSharedCache = false;
        if (AlfrescoTransactionSupport.getTransactionId() != null) {
            TransactionData txnData = this.getTransactionData();
            try {
                if (!txnData.isClearOn && txnData.removedItemsCache.get(key) != null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("get returning null - item has been removed from transactional cache: \n   cache: " + this + "\n" + "   key: " + key));
                    }
                    return null;
                }
                Element element = txnData.updatedItemsCache.get(key);
                if (element != null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Found item in transactional cache: \n   cache: " + this + "\n" + "   key: " + key + "\n" + "   value: " + element.getValue()));
                    }
                    return (V)element.getValue();
                }
            }
            catch (CacheException e) {
                throw new AlfrescoRuntimeException("Cache failure", (Throwable)e);
            }
            ignoreSharedCache = txnData.isClearOn;
        }
        if (!ignoreSharedCache) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("No value found in transaction - fetching instance from shared cache: \n   cache: " + this + "\n" + "   key: " + key + "\n" + "   value: " + this.sharedCache.get((Serializable)key)));
            }
            return (V)this.sharedCache.get((Serializable)key);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("No value found in transaction and ignoring shared cache: \n   cache: " + this + "\n" + "   key: " + key));
        }
        return null;
    }

    @Override
    public void put(K key, V value) {
        if (AlfrescoTransactionSupport.getTransactionId() == null) {
            this.sharedCache.put((Serializable)key, (Serializable)value);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("No transaction - adding item direct to shared cache: \n   cache: " + this + "\n" + "   key: " + key + "\n" + "   value: " + value));
            }
        } else {
            TransactionData txnData = this.getTransactionData();
            if (txnData.updatedItemsCache.getMemoryStoreSize() >= (long)this.maxCacheSize) {
                txnData.isClearOn = true;
            }
            Element element = new Element(key, value);
            txnData.updatedItemsCache.put(element);
            txnData.removedItemsCache.remove(key);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("In transaction - adding item direct to transactional update cache: \n   cache: " + this + "\n" + "   key: " + key + "\n" + "   value: " + value));
            }
        }
    }

    @Override
    public void remove(K key) {
        if (AlfrescoTransactionSupport.getTransactionId() == null) {
            this.sharedCache.remove((Serializable)key);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("No transaction - removing item from shared cache: \n   cache: " + this + "\n" + "   key: " + key));
            }
        } else {
            TransactionData txnData = this.getTransactionData();
            if (!txnData.isClearOn) {
                if (txnData.removedItemsCache.getMemoryStoreSize() >= (long)this.maxCacheSize) {
                    txnData.isClearOn = true;
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("In transaction - removal cache reach capacity reached: \n   cache: " + this + "\n" + "   txn: " + AlfrescoTransactionSupport.getTransactionId()));
                    }
                } else {
                    Element element = new Element(key, (Serializable)((Object)VALUE_DELETE));
                    txnData.removedItemsCache.put(element);
                }
            }
            txnData.updatedItemsCache.remove(key);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("In transaction - adding item direct to transactional removed cache: \n   cache: " + this + "\n" + "   key: " + key));
            }
        }
    }

    @Override
    public void clear() {
        if (AlfrescoTransactionSupport.getTransactionId() != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("In transaction clearing cache: \n   cache: " + this + "\n" + "   txn: " + AlfrescoTransactionSupport.getTransactionId()));
            }
            TransactionData txnData = this.getTransactionData();
            txnData.isClearOn = true;
            try {
                txnData.updatedItemsCache.removeAll();
                txnData.removedItemsCache.removeAll();
            }
            catch (IOException e) {
                throw new AlfrescoRuntimeException("Failed to clear caches", (Throwable)e);
            }
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"No transaction - clearing shared cache");
            }
            this.sharedCache.clear();
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public void beforeCommit(boolean readOnly) {
    }

    @Override
    public void beforeCompletion() {
    }

    @Override
    public void afterCommit() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Processing end of transaction commit");
        }
        TransactionData txnData = this.getTransactionData();
        try {
            List keys;
            if (txnData.isClearOn) {
                this.sharedCache.clear();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Clear notification recieved at end of transaction - clearing shared cache");
                }
            } else {
                keys = txnData.removedItemsCache.getKeys();
                for (Serializable key : keys) {
                    this.sharedCache.remove(key);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Removed " + keys.size() + " values from shared cache"));
                }
            }
            keys = txnData.updatedItemsCache.getKeys();
            for (Serializable key : keys) {
                Element element = txnData.updatedItemsCache.get(key);
                this.sharedCache.put(key, element.getValue());
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Added " + keys.size() + " values to shared cache"));
            }
        }
        catch (CacheException e) {
            throw new AlfrescoRuntimeException("Failed to transfer updates to shared cache", (Throwable)e);
        }
        finally {
            this.removeCaches(txnData);
        }
    }

    @Override
    public void afterRollback() {
        TransactionData txnData = this.getTransactionData();
        this.removeCaches(txnData);
    }

    private void removeCaches(TransactionData txnData) {
        this.cacheManager.removeCache(txnData.updatedItemsCache.getName());
        this.cacheManager.removeCache(txnData.removedItemsCache.getName());
    }

    private class TransactionData {
        public Cache updatedItemsCache;
        public Cache removedItemsCache;
        public boolean isClearOn;

        private TransactionData() {
        }
    }
}

