/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.cache;

import java.io.Serializable;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.cache.SimpleCache;
import org.jboss.cache.Fqn;
import org.jboss.cache.TreeCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeCacheAdapter<K extends Serializable, V extends Serializable>
implements SimpleCache<K, V> {
    private TreeCache cache;
    private Fqn regionFqn;

    public void setCache(TreeCache cache) {
        this.cache = cache;
    }

    public void setRegionName(String regionName) {
        this.regionFqn = new Fqn((Object)regionName);
    }

    @Override
    public boolean contains(K key) {
        try {
            return this.cache.exists(this.regionFqn, key);
        }
        catch (Throwable e) {
            throw new AlfrescoRuntimeException("contains failed", e);
        }
    }

    @Override
    public V get(K key) {
        try {
            Object element = this.cache.get(this.regionFqn, key);
            if (element != null) {
                return (V)((Serializable)element);
            }
            return null;
        }
        catch (Throwable e) {
            throw new AlfrescoRuntimeException("Failed to get from TreeCache: \n   key: " + key, e);
        }
    }

    @Override
    public void put(K key, V value) {
        try {
            this.cache.put(this.regionFqn, key, value);
        }
        catch (Throwable e) {
            throw new AlfrescoRuntimeException("Failed to put into TreeCache: \n   key: " + key + "\n" + "   value: " + value, e);
        }
    }

    @Override
    public void remove(K key) {
        try {
            this.cache.remove(this.regionFqn, key);
        }
        catch (Throwable e) {
            throw new AlfrescoRuntimeException("Failed to remove from TreeCache: \n   key: " + key, e);
        }
    }

    @Override
    public void clear() {
        try {
            this.cache.remove(this.regionFqn);
        }
        catch (Throwable e) {
            throw new AlfrescoRuntimeException("Failed to clear cache", e);
        }
    }
}

