/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.cache;

import java.io.Serializable;
import junit.framework.TestCase;
import org.alfresco.repo.cache.TreeCacheAdapter;
import org.jboss.cache.DummyTransactionManagerLookup;
import org.jboss.cache.Fqn;
import org.jboss.cache.TreeCache;

public class TreeCacheAdapterTest
extends TestCase {
    private static final String KEY_A = "A";
    private static final String VALUE_A = "AAA";
    private static final String KEY_B = "B";
    private static final String VALUE_B = "BBB";
    private TreeCache treeCache;
    private TreeCacheAdapter<Serializable, Serializable> cache;

    public void setUp() throws Exception {
        this.treeCache = new TreeCache();
        this.treeCache.setTransactionManagerLookupClass(DummyTransactionManagerLookup.class.getName());
        this.treeCache.start();
        this.cache = new TreeCacheAdapter();
        this.cache.setCache(this.treeCache);
        this.cache.setRegionName(this.getName());
    }

    public void testSimplePutGet() throws Exception {
        this.cache.put((Serializable)((Object)KEY_A), (Serializable)((Object)VALUE_A));
        this.cache.put((Serializable)((Object)KEY_B), (Serializable)((Object)VALUE_B));
        Serializable checkValueA = (Serializable)this.treeCache.get(new Fqn((Object)this.getName()), (Object)KEY_A);
        TreeCacheAdapterTest.assertNotNull((String)"Value A is not present in underlying cache", (Object)checkValueA);
        TreeCacheAdapterTest.assertEquals((String)"Value A is incorrect in underlying cache", (Object)VALUE_A, (Object)checkValueA);
        Serializable checkValueB = this.cache.get((Serializable)((Object)KEY_B));
        TreeCacheAdapterTest.assertNotNull((String)"Value B is not present in cache", (Object)checkValueB);
        TreeCacheAdapterTest.assertEquals((String)"Value B is incorrect in cache", (Object)VALUE_B, (Object)checkValueB);
    }
}

