/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.coci;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.i18n.I18NUtil;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.version.VersionableAspect;
import org.alfresco.service.cmr.coci.CheckOutCheckInService;
import org.alfresco.service.cmr.coci.CheckOutCheckInServiceException;
import org.alfresco.service.cmr.lock.LockService;
import org.alfresco.service.cmr.lock.LockType;
import org.alfresco.service.cmr.lock.UnableToReleaseLockException;
import org.alfresco.service.cmr.repository.AspectMissingException;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.CopyService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.AuthenticationService;
import org.alfresco.service.cmr.version.VersionService;
import org.alfresco.service.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckOutCheckInServiceImpl
implements CheckOutCheckInService {
    private static final String MSG_ERR_BAD_COPY = "coci_service.err_bad_copy";
    private static final String MSG_WORKING_COPY_LABEL = "coci_service.working_copy_label";
    private static final String MSG_ERR_NOT_OWNER = "coci_service.err_not_owner";
    private static final String MSG_ERR_ALREADY_WORKING_COPY = "coci_service.err_workingcopy_checkout";
    private static final String MSG_ERR_NOT_AUTHENTICATED = "coci_service.err_not_authenticated";
    private static final String MSG_ERR_WORKINGCOPY_HAS_NO_MIMETYPE = "coci_service.err_workingcopy_has_no_mimetype";
    private static final String EXTENSION_CHARACTER = ".";
    private NodeService nodeService;
    private VersionService versionService;
    private LockService lockService;
    private CopyService copyService;
    private SearchService searchService;
    private AuthenticationService authenticationService;
    private VersionableAspect versionableAspect;

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setVersionService(VersionService versionService) {
        this.versionService = versionService;
    }

    public void setLockService(LockService lockService) {
        this.lockService = lockService;
    }

    public void setCopyService(CopyService copyService) {
        this.copyService = copyService;
    }

    public void setAuthenticationService(AuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public void setVersionableAspect(VersionableAspect versionableAspect) {
        this.versionableAspect = versionableAspect;
    }

    public String getWorkingCopyLabel() {
        return I18NUtil.getMessage((String)MSG_WORKING_COPY_LABEL);
    }

    @Override
    public NodeRef checkout(NodeRef nodeRef, NodeRef destinationParentNodeRef, QName destinationAssocTypeQName, QName destinationAssocQName) {
        if (this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_WORKING_COPY)) {
            throw new CheckOutCheckInServiceException(MSG_ERR_ALREADY_WORKING_COPY);
        }
        if (!this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_LOCKABLE)) {
            this.nodeService.addAspect(nodeRef, ContentModel.ASPECT_LOCKABLE, null);
        }
        String copyName = (String)((Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_NAME));
        if (this.getWorkingCopyLabel() != null && this.getWorkingCopyLabel().length() != 0) {
            int index;
            copyName = copyName != null && copyName.length() != 0 ? ((index = copyName.lastIndexOf(EXTENSION_CHARACTER)) > 0 ? copyName.substring(0, index) + " " + this.getWorkingCopyLabel() + copyName.substring(index) : copyName + " " + this.getWorkingCopyLabel()) : this.getWorkingCopyLabel();
        }
        destinationAssocQName = QName.createQName(destinationAssocQName.getNamespaceURI(), QName.createValidLocalName(copyName));
        NodeRef workingCopy = this.copyService.copy(nodeRef, destinationParentNodeRef, destinationAssocTypeQName, destinationAssocQName);
        this.nodeService.setProperty(workingCopy, ContentModel.PROP_NAME, (Serializable)((Object)copyName));
        String userName = this.getUserName();
        HashMap<QName, Serializable> workingCopyProperties = new HashMap<QName, Serializable>(1);
        workingCopyProperties.put(ContentModel.PROP_WORKING_COPY_OWNER, (Serializable)((Object)userName));
        this.nodeService.addAspect(workingCopy, ContentModel.ASPECT_WORKING_COPY, workingCopyProperties);
        this.lockService.lock(nodeRef, LockType.READ_ONLY_LOCK);
        return workingCopy;
    }

    private String getUserName() {
        String un = this.authenticationService.getCurrentUserName();
        if (un != null) {
            return un;
        }
        throw new CheckOutCheckInServiceException(MSG_ERR_NOT_AUTHENTICATED);
    }

    @Override
    public NodeRef checkout(NodeRef nodeRef) {
        ChildAssociationRef childAssocRef = this.nodeService.getPrimaryParent(nodeRef);
        return this.checkout(nodeRef, childAssocRef.getParentRef(), childAssocRef.getTypeQName(), childAssocRef.getQName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NodeRef checkin(NodeRef workingCopyNodeRef, Map<String, Serializable> versionProperties, String contentUrl, boolean keepCheckedOut) {
        NodeRef nodeRef = null;
        if (!this.nodeService.hasAspect(workingCopyNodeRef, ContentModel.ASPECT_WORKING_COPY)) {
            throw new AspectMissingException(ContentModel.ASPECT_WORKING_COPY, workingCopyNodeRef);
        }
        if (this.nodeService.hasAspect(workingCopyNodeRef, ContentModel.ASPECT_COPIEDFROM)) {
            this.versionableAspect.disableAutoVersion();
            try {
                Map<QName, Serializable> workingCopyProperties = this.nodeService.getProperties(workingCopyNodeRef);
                nodeRef = (NodeRef)workingCopyProperties.get(ContentModel.PROP_COPY_REFERENCE);
                if (nodeRef == null) {
                    throw new CheckOutCheckInServiceException(MSG_ERR_BAD_COPY);
                }
                try {
                    this.lockService.unlock(nodeRef);
                }
                catch (UnableToReleaseLockException exception) {
                    throw new CheckOutCheckInServiceException(MSG_ERR_NOT_OWNER, exception);
                }
                if (contentUrl != null) {
                    ContentData contentData = (ContentData)workingCopyProperties.get(ContentModel.PROP_CONTENT);
                    if (contentData == null) {
                        throw new AlfrescoRuntimeException(MSG_ERR_WORKINGCOPY_HAS_NO_MIMETYPE, new Object[]{workingCopyNodeRef});
                    }
                    contentData = new ContentData(contentUrl, contentData.getMimetype(), contentData.getSize(), contentData.getEncoding());
                    this.nodeService.setProperty(workingCopyNodeRef, ContentModel.PROP_CONTENT, contentData);
                }
                this.copyService.copy(workingCopyNodeRef, nodeRef);
                if (versionProperties != null && this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_VERSIONABLE)) {
                    this.versionService.createVersion(nodeRef, versionProperties);
                }
                if (!keepCheckedOut) {
                    this.nodeService.removeAspect(workingCopyNodeRef, ContentModel.ASPECT_WORKING_COPY);
                    this.nodeService.deleteNode(workingCopyNodeRef);
                }
                this.lockService.lock(nodeRef, LockType.READ_ONLY_LOCK);
            }
            finally {
                this.versionableAspect.enableAutoVersion();
            }
        } else {
            throw new AspectMissingException(ContentModel.ASPECT_COPIEDFROM, workingCopyNodeRef);
        }
        return nodeRef;
    }

    @Override
    public NodeRef checkin(NodeRef workingCopyNodeRef, Map<String, Serializable> versionProperties, String contentUrl) {
        return this.checkin(workingCopyNodeRef, versionProperties, contentUrl, false);
    }

    @Override
    public NodeRef checkin(NodeRef workingCopyNodeRef, Map<String, Serializable> versionProperties) {
        return this.checkin(workingCopyNodeRef, versionProperties, null, false);
    }

    @Override
    public NodeRef cancelCheckout(NodeRef workingCopyNodeRef) {
        NodeRef nodeRef = null;
        if (!this.nodeService.hasAspect(workingCopyNodeRef, ContentModel.ASPECT_WORKING_COPY)) {
            throw new AspectMissingException(ContentModel.ASPECT_WORKING_COPY, workingCopyNodeRef);
        }
        if (this.nodeService.hasAspect(workingCopyNodeRef, ContentModel.ASPECT_COPIEDFROM)) {
            nodeRef = (NodeRef)this.nodeService.getProperty(workingCopyNodeRef, ContentModel.PROP_COPY_REFERENCE);
            if (nodeRef == null) {
                throw new CheckOutCheckInServiceException(MSG_ERR_BAD_COPY);
            }
        } else {
            throw new AspectMissingException(ContentModel.ASPECT_COPIEDFROM, workingCopyNodeRef);
        }
        this.lockService.unlock(nodeRef);
        this.nodeService.removeAspect(workingCopyNodeRef, ContentModel.ASPECT_WORKING_COPY);
        this.nodeService.deleteNode(workingCopyNodeRef);
        return nodeRef;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NodeRef getWorkingCopy(NodeRef nodeRef) {
        NodeRef workingCopy = null;
        ResultSet resultSet = null;
        try {
            resultSet = this.searchService.query(nodeRef.getStoreRef(), "lucene", "ASPECT:\"" + ContentModel.ASPECT_WORKING_COPY.toString() + "\" +@\\{http\\://www.alfresco.org/model/content/1.0\\}" + ContentModel.PROP_COPY_REFERENCE.getLocalName() + ":\"" + nodeRef.toString() + "\"");
            if (resultSet.getNodeRefs().size() != 0) {
                workingCopy = resultSet.getNodeRef(0);
            }
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
        }
        return workingCopy;
    }
}

