/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.coci;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import junit.framework.Assert;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.coci.CheckOutCheckInServiceImpl;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.transaction.TransactionUtil;
import org.alfresco.service.cmr.coci.CheckOutCheckInService;
import org.alfresco.service.cmr.lock.LockService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.security.AuthenticationService;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.version.Version;
import org.alfresco.service.cmr.version.VersionService;
import org.alfresco.service.cmr.version.VersionType;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.BaseSpringTest;
import org.alfresco.util.GUID;
import org.alfresco.util.TestWithUserUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckOutCheckInServiceImplTest
extends BaseSpringTest {
    private NodeService nodeService;
    private CheckOutCheckInService cociService;
    private ContentService contentService;
    private VersionService versionService;
    private AuthenticationService authenticationService;
    private LockService lockService;
    private TransactionService transactionService;
    private PermissionService permissionService;
    private StoreRef storeRef;
    private NodeRef rootNodeRef;
    private NodeRef nodeRef;
    private String userNodeRef;
    private static final String TEST_VALUE_NAME = "myDocument.doc";
    private static final String TEST_VALUE_2 = "testValue2";
    private static final String TEST_VALUE_3 = "testValue3";
    private static final QName PROP_NAME_QNAME = QName.createQName("http://www.alfresco.org/model/content/1.0", "name");
    private static final QName PROP2_QNAME = ContentModel.PROP_DESCRIPTION;
    private static final String CONTENT_1 = "This is some content";
    private static final String CONTENT_2 = "This is the cotent modified.";
    private String userName;
    private static final String PWD = "password";

    protected void onSetUpInTransaction() throws Exception {
        this.nodeService = (NodeService)this.applicationContext.getBean("nodeService");
        this.cociService = (CheckOutCheckInService)this.applicationContext.getBean("checkOutCheckInService");
        this.contentService = (ContentService)this.applicationContext.getBean("contentService");
        this.versionService = (VersionService)this.applicationContext.getBean("versionService");
        this.authenticationService = (AuthenticationService)this.applicationContext.getBean("authenticationService");
        this.lockService = (LockService)this.applicationContext.getBean("lockService");
        this.transactionService = (TransactionService)this.applicationContext.getBean("transactionComponent");
        this.permissionService = (PermissionService)this.applicationContext.getBean("permissionService");
        AuthenticationComponent authenticationComponent = (AuthenticationComponent)this.applicationContext.getBean("authenticationComponent");
        authenticationComponent.setSystemUserAsCurrentUser();
        this.storeRef = this.nodeService.createStore("workspace", "Test_" + System.currentTimeMillis());
        this.rootNodeRef = this.nodeService.getRootNode(this.storeRef);
        ChildAssociationRef childAssocRef = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName("{test}test"), ContentModel.TYPE_CONTENT);
        this.nodeRef = childAssocRef.getChildRef();
        this.nodeService.addAspect(this.nodeRef, ContentModel.ASPECT_TITLED, null);
        this.nodeService.setProperty(this.nodeRef, ContentModel.PROP_NAME, (Serializable)((Object)TEST_VALUE_NAME));
        this.nodeService.setProperty(this.nodeRef, PROP2_QNAME, (Serializable)((Object)TEST_VALUE_2));
        ContentWriter contentWriter = this.contentService.getWriter(this.nodeRef, ContentModel.PROP_CONTENT, true);
        contentWriter.setMimetype("text/plain");
        contentWriter.setEncoding("UTF-8");
        contentWriter.putContent(CONTENT_1);
        this.nodeService.addAspect(this.nodeRef, ContentModel.ASPECT_VERSIONABLE, null);
        this.nodeService.addAspect(this.nodeRef, ContentModel.ASPECT_LOCKABLE, null);
        this.userName = "cociTest" + GUID.generate();
        TestWithUserUtils.createUser(this.userName, PWD, this.rootNodeRef, this.nodeService, this.authenticationService);
        TestWithUserUtils.authenticateUser(this.userName, PWD, this.rootNodeRef, this.authenticationService);
        this.userNodeRef = TestWithUserUtils.getCurrentUser(this.authenticationService);
        this.permissionService.setPermission(this.rootNodeRef, this.userName.toLowerCase(), "All", true);
        this.permissionService.setPermission(this.nodeRef, this.userName.toLowerCase(), "All", true);
    }

    private Map<QName, Serializable> createTypePropertyBag() {
        HashMap<QName, Serializable> result = new HashMap<QName, Serializable>();
        result.put(PROP_NAME_QNAME, (Serializable)((Object)TEST_VALUE_NAME));
        return result;
    }

    public void testCheckOut() {
        this.checkout();
    }

    private NodeRef checkout() {
        NodeRef workingCopy = this.cociService.checkout(this.nodeRef, this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName("{test}workingCopy"));
        CheckOutCheckInServiceImplTest.assertNotNull((Object)workingCopy);
        CheckOutCheckInServiceImplTest.assertTrue((boolean)this.nodeService.hasAspect(workingCopy, ContentModel.ASPECT_WORKING_COPY));
        CheckOutCheckInServiceImplTest.assertTrue((boolean)this.nodeService.hasAspect(workingCopy, ContentModel.ASPECT_COPIEDFROM));
        CheckOutCheckInServiceImplTest.assertEquals((Object)this.userNodeRef, (Object)this.nodeService.getProperty(workingCopy, ContentModel.PROP_WORKING_COPY_OWNER));
        String workingCopyLabel = ((CheckOutCheckInServiceImpl)this.cociService).getWorkingCopyLabel();
        String workingCopyName = (String)((Object)this.nodeService.getProperty(workingCopy, PROP_NAME_QNAME));
        if (workingCopyLabel == null || workingCopyLabel.length() == 0) {
            CheckOutCheckInServiceImplTest.assertEquals((String)TEST_VALUE_NAME, (String)workingCopyName);
        } else {
            CheckOutCheckInServiceImplTest.assertEquals((String)("myDocument " + workingCopyLabel + ".doc"), (String)workingCopyName);
        }
        ContentReader contentReader = this.contentService.getReader(this.nodeRef, ContentModel.PROP_CONTENT);
        CheckOutCheckInServiceImplTest.assertNotNull((Object)contentReader);
        ContentReader contentReader2 = this.contentService.getReader(workingCopy, ContentModel.PROP_CONTENT);
        CheckOutCheckInServiceImplTest.assertNotNull((Object)contentReader2);
        CheckOutCheckInServiceImplTest.assertEquals((String)"The content string of the working copy should match the original immediatly after checkout.", (String)contentReader.getContentString(), (String)contentReader2.getContentString());
        return workingCopy;
    }

    public void testCheckIn() {
        NodeRef workingCopy = this.checkout();
        HashMap<String, Serializable> versionProperties = new HashMap<String, Serializable>();
        versionProperties.put("description", (Serializable)((Object)"This is a test version"));
        this.cociService.checkin(workingCopy, versionProperties);
        NodeRef workingCopy3 = this.checkout();
        this.nodeService.setProperty(workingCopy3, PROP_NAME_QNAME, (Serializable)((Object)TEST_VALUE_2));
        this.nodeService.setProperty(workingCopy3, PROP2_QNAME, (Serializable)((Object)TEST_VALUE_3));
        ContentWriter tempWriter = this.contentService.getWriter(workingCopy3, ContentModel.PROP_CONTENT, false);
        CheckOutCheckInServiceImplTest.assertNotNull((Object)tempWriter);
        tempWriter.putContent(CONTENT_2);
        String contentUrl = tempWriter.getContentUrl();
        HashMap<String, Serializable> versionProperties3 = new HashMap<String, Serializable>();
        versionProperties3.put("description", (Serializable)((Object)"description"));
        versionProperties3.put("versionType", (Serializable)((Object)VersionType.MAJOR));
        NodeRef origNodeRef = this.cociService.checkin(workingCopy3, versionProperties3, contentUrl, true);
        CheckOutCheckInServiceImplTest.assertNotNull((Object)origNodeRef);
        ContentReader contentReader = this.contentService.getReader(origNodeRef, ContentModel.PROP_CONTENT);
        CheckOutCheckInServiceImplTest.assertNotNull((Object)contentReader);
        CheckOutCheckInServiceImplTest.assertEquals((String)CONTENT_2, (String)contentReader.getContentString());
        Version version = this.versionService.getCurrentVersion(origNodeRef);
        CheckOutCheckInServiceImplTest.assertNotNull((Object)version);
        CheckOutCheckInServiceImplTest.assertEquals((String)"description", (String)version.getDescription());
        CheckOutCheckInServiceImplTest.assertEquals((Object)((Object)VersionType.MAJOR), (Object)((Object)version.getVersionType()));
        NodeRef versionNodeRef = version.getFrozenStateNodeRef();
        CheckOutCheckInServiceImplTest.assertNotNull((Object)versionNodeRef);
        ContentReader versionContentReader = this.contentService.getReader(versionNodeRef, ContentModel.PROP_CONTENT);
        CheckOutCheckInServiceImplTest.assertNotNull((Object)versionContentReader);
        CheckOutCheckInServiceImplTest.assertEquals((String)CONTENT_2, (String)versionContentReader.getContentString());
        CheckOutCheckInServiceImplTest.assertEquals((Object)TEST_VALUE_NAME, (Object)this.nodeService.getProperty(versionNodeRef, PROP_NAME_QNAME));
        CheckOutCheckInServiceImplTest.assertEquals((Object)TEST_VALUE_NAME, (Object)this.nodeService.getProperty(origNodeRef, PROP_NAME_QNAME));
        CheckOutCheckInServiceImplTest.assertEquals((Object)TEST_VALUE_3, (Object)this.nodeService.getProperty(versionNodeRef, PROP2_QNAME));
        CheckOutCheckInServiceImplTest.assertEquals((Object)TEST_VALUE_3, (Object)this.nodeService.getProperty(origNodeRef, PROP2_QNAME));
        this.cociService.cancelCheckout(workingCopy3);
        NodeRef workingCopy2 = this.checkout();
        HashMap<String, Serializable> versionProperties2 = new HashMap<String, Serializable>();
        versionProperties2.put("description", (Serializable)((Object)"Another version test"));
        this.cociService.checkin(workingCopy2, versionProperties2, null, true);
        this.cociService.checkin(workingCopy2, new HashMap<String, Serializable>(), null, true);
    }

    public void testCheckOutCheckInWithTranslatableAspect() {
        NodeRef translationNodeRef = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName("{test}translation"), ContentModel.TYPE_CONTENT).getChildRef();
        this.nodeService.addAspect(this.nodeRef, QName.createQName("http://www.alfresco.org/model/content/1.0", "translatable"), null);
        this.nodeService.createAssociation(this.nodeRef, translationNodeRef, QName.createQName("http://www.alfresco.org/model/content/1.0", "translations"));
        NodeRef workingCopy = this.cociService.checkout(this.nodeRef, this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName("{test}workingCopy"));
        HashMap<String, Serializable> versionProperties = new HashMap<String, Serializable>();
        versionProperties.put("description", (Serializable)((Object)"This is a test version"));
        this.cociService.checkin(workingCopy, versionProperties);
    }

    public void testVersionAspectNotSetOnCheckIn() {
        Map<QName, Serializable> bagOfProps = this.createTypePropertyBag();
        bagOfProps.put(ContentModel.PROP_CONTENT, new ContentData(null, "text/plain", 0L, "UTF-8"));
        ChildAssociationRef childAssocRef = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName("{test}test"), ContentModel.TYPE_CONTENT, bagOfProps);
        NodeRef noVersionNodeRef = childAssocRef.getChildRef();
        NodeRef workingCopy = this.cociService.checkout(noVersionNodeRef);
        this.cociService.checkin(workingCopy, new HashMap<String, Serializable>());
        CheckOutCheckInServiceImplTest.assertNull((Object)this.versionService.getVersionHistory(noVersionNodeRef));
    }

    public void testCancelCheckOut() {
        NodeRef workingCopy = this.checkout();
        CheckOutCheckInServiceImplTest.assertNotNull((Object)workingCopy);
        try {
            this.lockService.checkForLock(this.nodeRef);
            CheckOutCheckInServiceImplTest.fail((String)"The origional should be locked now.");
        }
        catch (Throwable exception) {
            // empty catch block
        }
        NodeRef origNodeRef = this.cociService.cancelCheckout(workingCopy);
        CheckOutCheckInServiceImplTest.assertEquals((Object)this.nodeRef, (Object)origNodeRef);
        this.lockService.checkForLock(origNodeRef);
    }

    public void testAutoCancelCheckOut() {
        NodeRef workingCopy = this.checkout();
        CheckOutCheckInServiceImplTest.assertNotNull((Object)workingCopy);
        try {
            this.lockService.checkForLock(this.nodeRef);
            CheckOutCheckInServiceImplTest.fail((String)"The origional should be locked now.");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.nodeService.deleteNode(workingCopy);
        this.lockService.checkForLock(this.nodeRef);
    }

    public void testGetWorkingCopy() {
        NodeRef origNodeRef = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName("{test}test2"), ContentModel.TYPE_CONTENT).getChildRef();
        NodeRef wk1 = this.cociService.getWorkingCopy(origNodeRef);
        CheckOutCheckInServiceImplTest.assertNull((Object)wk1);
        final NodeRef workingCopy = this.cociService.checkout(origNodeRef);
        this.setComplete();
        this.endTransaction();
        final NodeRef finalNodeRef = origNodeRef;
        TransactionUtil.executeInUserTransaction(this.transactionService, new TransactionUtil.TransactionWork<Object>(){

            @Override
            public Object doWork() {
                NodeRef wk2 = CheckOutCheckInServiceImplTest.this.cociService.getWorkingCopy(finalNodeRef);
                Assert.assertNotNull((Object)wk2);
                Assert.assertEquals((Object)workingCopy, (Object)wk2);
                CheckOutCheckInServiceImplTest.this.cociService.cancelCheckout(workingCopy);
                return null;
            }
        });
        NodeRef wk3 = this.cociService.getWorkingCopy(this.nodeRef);
        CheckOutCheckInServiceImplTest.assertNull((Object)wk3);
    }
}

