/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.coci;

import org.alfresco.model.ContentModel;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.policy.PolicyScope;
import org.alfresco.service.cmr.lock.LockService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.QName;

public class WorkingCopyAspect {
    private PolicyComponent policyComponent;
    private NodeService nodeService;
    private LockService lockService;

    public void setPolicyComponent(PolicyComponent policyComponent) {
        this.policyComponent = policyComponent;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setLockService(LockService lockService) {
        this.lockService = lockService;
    }

    public void init() {
        this.policyComponent.bindClassBehaviour(QName.createQName("http://www.alfresco.org", "onCopyNode"), ContentModel.ASPECT_WORKING_COPY, (Behaviour)new JavaBehaviour(this, "onCopy"));
        this.policyComponent.bindClassBehaviour(QName.createQName("http://www.alfresco.org", "beforeDeleteNode"), ContentModel.ASPECT_WORKING_COPY, (Behaviour)new JavaBehaviour(this, "beforeDeleteNode"));
    }

    public void onCopy(QName sourceClassRef, NodeRef sourceNodeRef, StoreRef destinationStoreRef, boolean copyToNewNode, PolicyScope copyDetails) {
        if (!copyToNewNode) {
            copyDetails.removeProperty(ContentModel.PROP_NAME);
        }
    }

    public void beforeDeleteNode(NodeRef nodeRef) {
        NodeRef origNodeRef;
        if (this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_WORKING_COPY) && this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_COPIEDFROM) && (origNodeRef = (NodeRef)this.nodeService.getProperty(nodeRef, ContentModel.PROP_COPY_REFERENCE)) != null) {
            this.lockService.unlock(origNodeRef);
        }
    }
}

