/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.configuration;

import java.util.List;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.configuration.ConfigurableService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.RegexQNamePattern;

public class ConfigurableServiceImpl
implements ConfigurableService {
    private NodeService nodeService;

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public boolean isConfigurable(NodeRef nodeRef) {
        return this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_CONFIGURABLE);
    }

    public void makeConfigurable(NodeRef nodeRef) {
        if (!this.isConfigurable(nodeRef)) {
            this.nodeService.addAspect(nodeRef, ContentModel.ASPECT_CONFIGURABLE, null);
            this.nodeService.createNode(nodeRef, ContentModel.ASSOC_CONFIGURATIONS, ContentModel.ASSOC_CONFIGURATIONS, ContentModel.TYPE_CONFIGURATIONS);
        }
    }

    public NodeRef getConfigurationFolder(NodeRef nodeRef) {
        List<ChildAssociationRef> assocs;
        NodeRef result = null;
        if (this.isConfigurable(nodeRef) && (assocs = this.nodeService.getChildAssocs(nodeRef, RegexQNamePattern.MATCH_ALL, ContentModel.ASSOC_CONFIGURATIONS)).size() != 0) {
            ChildAssociationRef assoc = assocs.get(0);
            result = assoc.getChildRef();
        }
        return result;
    }
}

