/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.configuration;

import java.util.List;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.configuration.ConfigurableService;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.util.BaseSpringTest;

public class ConfigurableServiceImplTest
extends BaseSpringTest {
    public NodeService nodeService;
    private ServiceRegistry serviceRegistry;
    private ConfigurableService configurableService;
    private StoreRef testStoreRef;
    private NodeRef rootNodeRef;
    private NodeRef nodeRef;

    protected void onSetUpInTransaction() throws Exception {
        this.nodeService = (NodeService)this.applicationContext.getBean("nodeService");
        this.serviceRegistry = (ServiceRegistry)this.applicationContext.getBean("ServiceRegistry");
        this.configurableService = (ConfigurableService)this.applicationContext.getBean("configurableService");
        this.testStoreRef = this.nodeService.createStore("workspace", "Test_" + System.currentTimeMillis());
        this.rootNodeRef = this.nodeService.getRootNode(this.testStoreRef);
        this.nodeRef = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, ContentModel.ASSOC_CHILDREN, ContentModel.TYPE_CONTAINER).getChildRef();
    }

    public void testIsConfigurable() {
        ConfigurableServiceImplTest.assertFalse((boolean)this.configurableService.isConfigurable(this.nodeRef));
        this.configurableService.makeConfigurable(this.nodeRef);
        ConfigurableServiceImplTest.assertTrue((boolean)this.configurableService.isConfigurable(this.nodeRef));
    }

    public void testMakeConfigurable() {
        this.configurableService.makeConfigurable(this.nodeRef);
        ConfigurableServiceImplTest.assertTrue((boolean)this.nodeService.hasAspect(this.nodeRef, ContentModel.ASPECT_CONFIGURABLE));
        List<ChildAssociationRef> assocs = this.nodeService.getChildAssocs(this.nodeRef, RegexQNamePattern.MATCH_ALL, ContentModel.ASSOC_CONFIGURATIONS);
        ConfigurableServiceImplTest.assertNotNull(assocs);
        ConfigurableServiceImplTest.assertEquals((int)1, (int)assocs.size());
    }

    public void testGetConfigurationFolder() {
        ConfigurableServiceImplTest.assertNull((Object)this.configurableService.getConfigurationFolder(this.nodeRef));
        this.configurableService.makeConfigurable(this.nodeRef);
        NodeRef configFolder = this.configurableService.getConfigurationFolder(this.nodeRef);
        ConfigurableServiceImplTest.assertNotNull((Object)configFolder);
        NodeRef parentNodeRef = this.nodeService.getPrimaryParent(configFolder).getParentRef();
        ConfigurableServiceImplTest.assertNotNull((Object)parentNodeRef);
        ConfigurableServiceImplTest.assertEquals((Object)this.nodeRef, (Object)parentNodeRef);
    }
}

