/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content;

import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.List;
import org.alfresco.error.StackTraceUtil;
import org.alfresco.repo.transaction.TransactionUtil;
import org.alfresco.service.cmr.repository.ContentAccessor;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.ContentIOException;
import org.alfresco.service.cmr.repository.ContentStreamListener;
import org.alfresco.service.transaction.TransactionService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.AfterReturningAdvice;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractContentAccessor
implements ContentAccessor {
    private static Log logger = LogFactory.getLog(AbstractContentAccessor.class);
    private static final Log loggerTrace = LogFactory.getLog((String)(AbstractContentAccessor.class.getName() + ".trace"));
    private StackTraceElement[] traceLoggerChannelAssignTrace;
    private TransactionService transactionService;
    private String contentUrl;
    private String mimetype;
    private String encoding;

    protected AbstractContentAccessor(String contentUrl) {
        if (contentUrl == null || contentUrl.length() == 0) {
            throw new IllegalArgumentException("contentUrl must be a valid String");
        }
        this.contentUrl = contentUrl;
        this.encoding = "UTF-8";
    }

    protected void finalize() throws Throwable {
        if (loggerTrace.isDebugEnabled() && this.traceLoggerChannelAssignTrace != null && this.isChannelOpen()) {
            StringBuilder sb = new StringBuilder(1024);
            StackTraceUtil.buildStackTrace((String)("Content IO Channel was opened but not closed: \n" + this), (StackTraceElement[])this.traceLoggerChannelAssignTrace, (StringBuilder)sb, (int)-1);
            loggerTrace.error((Object)sb);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(100);
        sb.append("ContentAccessor").append("[ contentUrl=").append(this.getContentUrl()).append(", mimetype=").append(this.getMimetype()).append(", size=").append(this.getSize()).append(", encoding=").append(this.getEncoding()).append("]");
        return sb.toString();
    }

    @Override
    public ContentData getContentData() {
        ContentData property = new ContentData(this.contentUrl, this.mimetype, this.getSize(), this.encoding);
        return property;
    }

    protected TransactionService getTransactionService() {
        return this.transactionService;
    }

    @Override
    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    protected final void channelOpened() {
        if (loggerTrace.isDebugEnabled()) {
            Exception e = new Exception();
            e.fillInStackTrace();
            this.traceLoggerChannelAssignTrace = e.getStackTrace();
        }
    }

    protected abstract boolean isChannelOpen();

    @Override
    public String getContentUrl() {
        return this.contentUrl;
    }

    @Override
    public String getMimetype() {
        return this.mimetype;
    }

    @Override
    public void setMimetype(String mimetype) {
        this.mimetype = mimetype;
    }

    @Override
    public String getEncoding() {
        return this.encoding;
    }

    @Override
    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    protected FileChannel getCallbackFileChannel(FileChannel directChannel, List<ContentStreamListener> listeners) throws ContentIOException {
        CallbackFileChannel ret = new CallbackFileChannel(directChannel, listeners);
        return ret;
    }

    static {
        if (loggerTrace.isDebugEnabled()) {
            loggerTrace.warn((Object)"Trace channel assignment logging is on and will affect performance");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class CallbackFileChannel
    extends FileChannel {
        private FileChannel delegate;
        private List<ContentStreamListener> listeners;

        public CallbackFileChannel(FileChannel delegate, List<ContentStreamListener> listeners) {
            if (delegate == null) {
                throw new IllegalArgumentException("FileChannel delegate is required");
            }
            if (delegate instanceof CallbackFileChannel) {
                throw new IllegalArgumentException("FileChannel delegate may not be a CallbackFileChannel");
            }
            this.delegate = delegate;
            this.listeners = listeners;
        }

        @Override
        protected void implCloseChannel() throws IOException {
            this.delegate.close();
            this.fireChannelClosed();
        }

        private void fireChannelClosed() {
            if (this.listeners.size() == 0) {
                return;
            }
            TransactionUtil.TransactionWork<Object> work = new TransactionUtil.TransactionWork<Object>(){

                @Override
                public Object doWork() {
                    for (ContentStreamListener listener : CallbackFileChannel.this.listeners) {
                        listener.contentStreamClosed();
                    }
                    return null;
                }
            };
            if (AbstractContentAccessor.this.transactionService != null) {
                TransactionUtil.executeInUserTransaction(AbstractContentAccessor.this.transactionService, work);
            } else {
                try {
                    work.doWork();
                }
                catch (Exception e) {
                    throw new ContentIOException("Failed to executed channel close callbacks", e);
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("" + this.listeners.size() + " content listeners called: close"));
            }
        }

        @Override
        public void force(boolean metaData) throws IOException {
            this.delegate.force(metaData);
        }

        @Override
        public FileLock lock(long position, long size, boolean shared) throws IOException {
            return this.delegate.lock(position, size, shared);
        }

        @Override
        public MappedByteBuffer map(FileChannel.MapMode mode, long position, long size) throws IOException {
            return this.delegate.map(mode, position, size);
        }

        @Override
        public long position() throws IOException {
            return this.delegate.position();
        }

        @Override
        public FileChannel position(long newPosition) throws IOException {
            return this.delegate.position(newPosition);
        }

        @Override
        public int read(ByteBuffer dst) throws IOException {
            return this.delegate.read(dst);
        }

        @Override
        public int read(ByteBuffer dst, long position) throws IOException {
            return this.delegate.read(dst, position);
        }

        @Override
        public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
            return this.delegate.read(dsts, offset, length);
        }

        @Override
        public long size() throws IOException {
            return this.delegate.size();
        }

        @Override
        public long transferFrom(ReadableByteChannel src, long position, long count) throws IOException {
            return this.delegate.transferFrom(src, position, count);
        }

        @Override
        public long transferTo(long position, long count, WritableByteChannel target) throws IOException {
            return this.delegate.transferTo(position, count, target);
        }

        @Override
        public FileChannel truncate(long size) throws IOException {
            return this.delegate.truncate(size);
        }

        @Override
        public FileLock tryLock(long position, long size, boolean shared) throws IOException {
            return this.delegate.tryLock(position, size, shared);
        }

        @Override
        public int write(ByteBuffer src) throws IOException {
            return this.delegate.write(src);
        }

        @Override
        public int write(ByteBuffer src, long position) throws IOException {
            return this.delegate.write(src, position);
        }

        @Override
        public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
            return this.delegate.write(srcs, offset, length);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ChannelCloseCallbackAdvise
    implements AfterReturningAdvice {
        private List<ContentStreamListener> listeners;

        public ChannelCloseCallbackAdvise(List<ContentStreamListener> listeners) {
            this.listeners = listeners;
        }

        public void afterReturning(Object returnValue, Method method, Object[] args, Object target) throws Throwable {
            if (method.getName().equals("close")) {
                this.fireChannelClosed();
            }
        }

        private void fireChannelClosed() {
            if (this.listeners.size() == 0) {
                return;
            }
            TransactionUtil.TransactionWork<Object> work = new TransactionUtil.TransactionWork<Object>(){

                @Override
                public Object doWork() {
                    for (ContentStreamListener listener : ChannelCloseCallbackAdvise.this.listeners) {
                        listener.contentStreamClosed();
                    }
                    return null;
                }
            };
            if (AbstractContentAccessor.this.transactionService != null) {
                TransactionUtil.executeInUserTransaction(AbstractContentAccessor.this.transactionService, work);
            } else {
                try {
                    work.doWork();
                }
                catch (Exception e) {
                    throw new ContentIOException("Failed to executed channel close callbacks", e);
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("" + this.listeners.size() + " content listeners called: close"));
            }
        }
    }
}

