/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.util.Date;
import java.util.Set;
import javax.transaction.UserTransaction;
import junit.framework.TestCase;
import org.alfresco.repo.content.AbstractContentStore;
import org.alfresco.repo.content.ContentStore;
import org.alfresco.repo.transaction.DummyTransactionService;
import org.alfresco.service.cmr.repository.ContentIOException;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentStreamListener;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.springframework.context.ApplicationContext;

public abstract class AbstractContentReadWriteTest
extends TestCase {
    private static final ApplicationContext ctx = ApplicationContextHelper.getApplicationContext();
    protected TransactionService transactionService;
    private String contentUrl;
    private UserTransaction txn;

    public void setUp() throws Exception {
        this.contentUrl = AbstractContentStore.createNewUrl();
        this.transactionService = (TransactionService)ctx.getBean("TransactionService");
        this.txn = this.transactionService.getUserTransaction();
        this.txn.begin();
    }

    public void tearDown() throws Exception {
        this.txn.rollback();
    }

    protected abstract ContentStore getStore();

    protected final ContentWriter getWriter() {
        return this.getStore().getWriter(null, this.contentUrl);
    }

    protected final ContentReader getReader() {
        return this.getStore().getReader(this.contentUrl);
    }

    public void testSetUp() throws Exception {
        AbstractContentReadWriteTest.assertNotNull((Object)"setUp() not executed: no content URL present");
        ContentStore store = this.getStore();
        AbstractContentReadWriteTest.assertNotNull((String)"No store provided", (Object)store);
        AbstractContentReadWriteTest.assertTrue((String)"The same instance of the store must be returned for getStore", (store == this.getStore() ? 1 : 0) != 0);
    }

    public void testContentUrl() throws Exception {
        ContentReader reader = this.getReader();
        ContentWriter writer = this.getWriter();
        String readerContentUrl = reader.getContentUrl();
        String writerContentUrl = writer.getContentUrl();
        AbstractContentReadWriteTest.assertNotNull((String)"Reader url is invalid", (Object)readerContentUrl);
        AbstractContentReadWriteTest.assertNotNull((String)"Writer url is invalid", (Object)writerContentUrl);
        AbstractContentReadWriteTest.assertEquals((String)"Reader and writer must reference same content", (String)readerContentUrl, (String)writerContentUrl);
        AbstractContentReadWriteTest.assertTrue((String)"Content URL doesn't start with correct prefix", (boolean)readerContentUrl.startsWith("store://"));
    }

    public void testMimetypeAndEncoding() throws Exception {
        ContentWriter writer = this.getWriter();
        writer.setMimetype("text/plain");
        writer.setEncoding("UTF-16");
        String content = "A little bit o' this and a little bit o' that";
        byte[] bytesUtf16 = content.getBytes("UTF-16");
        OutputStream os = writer.getContentOutputStream();
        os.write(bytesUtf16);
        os.close();
        ContentReader reader = writer.getReader();
        AbstractContentReadWriteTest.assertEquals((String)"Writer -> Reader content URL mismatch", (String)writer.getContentUrl(), (String)reader.getContentUrl());
        AbstractContentReadWriteTest.assertEquals((String)"Writer -> Reader mimetype mismatch", (String)writer.getMimetype(), (String)reader.getMimetype());
        AbstractContentReadWriteTest.assertEquals((String)"Writer -> Reader encoding mismatch", (String)writer.getEncoding(), (String)reader.getEncoding());
        String contentCheck = reader.getContentString();
        AbstractContentReadWriteTest.assertEquals((String)"Encoding and decoding of strings failed", (String)content, (String)contentCheck);
    }

    public void testExists() throws Exception {
        ContentStore store = this.getStore();
        String contentUrl = AbstractContentStore.createNewUrl();
        AbstractContentReadWriteTest.assertFalse((String)"Store exists fails with new URL", (boolean)store.exists(contentUrl));
        ContentReader reader = store.getReader(contentUrl);
        AbstractContentReadWriteTest.assertNotNull((String)"Reader must be present, even for missing content", (Object)reader);
        AbstractContentReadWriteTest.assertFalse((String)"Reader exists failure", (boolean)reader.exists());
        ContentWriter writer = store.getWriter(null, contentUrl);
        writer.putContent("ABC");
        AbstractContentReadWriteTest.assertTrue((String)"Store exists should show URL to be present", (boolean)store.exists(contentUrl));
    }

    public void testGetReader() throws Exception {
        ContentWriter writer = this.getWriter();
        ContentReader nullReader = writer.getReader();
        AbstractContentReadWriteTest.assertNull((String)"No reader expected", (Object)nullReader);
        String content = "ABC";
        writer.setMimetype("text/plain");
        writer.setEncoding("UTF-8");
        writer.putContent(content);
        ContentReader readerFromWriter = writer.getReader();
        AbstractContentReadWriteTest.assertEquals((String)"URL incorrect", (String)writer.getContentUrl(), (String)readerFromWriter.getContentUrl());
        AbstractContentReadWriteTest.assertEquals((String)"Mimetype incorrect", (String)writer.getMimetype(), (String)readerFromWriter.getMimetype());
        AbstractContentReadWriteTest.assertEquals((String)"Encoding incorrect", (String)writer.getEncoding(), (String)readerFromWriter.getEncoding());
        ContentReader readerFromReader = readerFromWriter.getReader();
        AbstractContentReadWriteTest.assertEquals((String)"URL incorrect", (String)writer.getContentUrl(), (String)readerFromReader.getContentUrl());
        AbstractContentReadWriteTest.assertEquals((String)"Mimetype incorrect", (String)writer.getMimetype(), (String)readerFromReader.getMimetype());
        AbstractContentReadWriteTest.assertEquals((String)"Encoding incorrect", (String)writer.getEncoding(), (String)readerFromReader.getEncoding());
        String contentCheck = readerFromWriter.getContentString();
        AbstractContentReadWriteTest.assertEquals((String)"Content is incorrect", (String)content, (String)contentCheck);
        int length = content.getBytes(writer.getEncoding()).length;
        AbstractContentReadWriteTest.assertEquals((String)"Reader content length is incorrect", (long)length, (long)readerFromWriter.getSize());
    }

    public void testClosedState() throws Exception {
        ContentReader reader = this.getReader();
        ContentWriter writer = this.getWriter();
        AbstractContentReadWriteTest.assertFalse((String)"Reader stream should not be closed", (boolean)reader.isClosed());
        AbstractContentReadWriteTest.assertFalse((String)"Writer stream should not be closed", (boolean)writer.isClosed());
        ContentReader writerGivenReader = writer.getReader();
        AbstractContentReadWriteTest.assertNull((String)"No reader should be available before a write has finished", (Object)writerGivenReader);
        writer.putContent("ABC");
        AbstractContentReadWriteTest.assertTrue((String)"Writer stream should be closed", (boolean)writer.isClosed());
        writerGivenReader = writer.getReader();
        AbstractContentReadWriteTest.assertNotNull((String)"No reader given by closed writer", (Object)writerGivenReader);
        AbstractContentReadWriteTest.assertFalse((String)"Readers should still be closed", (boolean)reader.isClosed());
        AbstractContentReadWriteTest.assertFalse((String)"Readers should still be closed", (boolean)writerGivenReader.isClosed());
        ContentReader newReaderA = writer.getReader();
        ContentReader newReaderB = writer.getReader();
        AbstractContentReadWriteTest.assertFalse((String)"Reader must always be a new instance", (newReaderA == newReaderB ? 1 : 0) != 0);
        AbstractContentReadWriteTest.assertEquals((String)"Readers should refer to same URL", (String)reader.getContentUrl(), (String)writerGivenReader.getContentUrl());
        String contentCheck = reader.getContentString();
        AbstractContentReadWriteTest.assertEquals((String)"Incorrect content", (String)"ABC", (String)contentCheck);
        contentCheck = writerGivenReader.getContentString();
        AbstractContentReadWriteTest.assertEquals((String)"Incorrect content", (String)"ABC", (String)contentCheck);
        AbstractContentReadWriteTest.assertTrue((String)"Reader should be closed", (boolean)reader.isClosed());
        AbstractContentReadWriteTest.assertTrue((String)"Reader should be closed", (boolean)writerGivenReader.isClosed());
    }

    public void testConcurrentWriteDetection() throws Exception {
        String contentUrl = AbstractContentStore.createNewUrl();
        ContentStore store = this.getStore();
        ContentWriter firstWriter = store.getWriter(null, contentUrl);
        try {
            ContentWriter secondWriter = store.getWriter(null, contentUrl);
            AbstractContentReadWriteTest.fail((String)("Store issued two writers for the same URL: " + store));
        }
        catch (ContentIOException e) {
            // empty catch block
        }
    }

    public void testWriteStreamListener() throws Exception {
        ContentWriter writer = this.getWriter();
        final boolean[] streamClosed = new boolean[]{false};
        ContentStreamListener listener = new ContentStreamListener(){

            public void contentStreamClosed() throws ContentIOException {
                streamClosed[0] = true;
            }
        };
        writer.setTransactionService(new DummyTransactionService());
        writer.addListener(listener);
        writer.putContent("ABC");
        AbstractContentReadWriteTest.assertTrue((String)"Write stream listener was not called for the stream close", (boolean)streamClosed[0]);
    }

    public void testWriteAndReadString() throws Exception {
        ContentReader reader = this.getReader();
        ContentWriter writer = this.getWriter();
        String content = "ABC";
        writer.putContent(content);
        AbstractContentReadWriteTest.assertTrue((String)"Stream close not detected", (boolean)writer.isClosed());
        String check = reader.getContentString();
        AbstractContentReadWriteTest.assertTrue((String)"Read and write may not share same resource", (check.length() > 0 ? 1 : 0) != 0);
        AbstractContentReadWriteTest.assertEquals((String)"Write and read didn't work", (String)content, (String)check);
    }

    public void testStringTruncation() throws Exception {
        String content = "1234567890";
        ContentWriter writer = this.getWriter();
        writer.setMimetype("text/plain");
        writer.setEncoding("UTF-8");
        writer.putContent(content);
        ContentReader reader = writer.getReader();
        String checkContent = reader.getContentString(5);
        AbstractContentReadWriteTest.assertEquals((String)"Truncated strings don't match", (String)"12345", (String)checkContent);
    }

    public void testReadAndWriteFile() throws Exception {
        ContentReader reader = this.getReader();
        ContentWriter writer = this.getWriter();
        File sourceFile = File.createTempFile(this.getName(), ".txt");
        sourceFile.deleteOnExit();
        String content = "ABC";
        FileOutputStream os = new FileOutputStream(sourceFile);
        os.write(content.getBytes());
        os.flush();
        os.close();
        writer.putContent(sourceFile);
        AbstractContentReadWriteTest.assertTrue((String)"Stream close not detected", (boolean)writer.isClosed());
        File sinkFile = File.createTempFile(this.getName(), ".txt");
        sinkFile.deleteOnExit();
        reader.getContent(sinkFile);
        FileInputStream is = new FileInputStream(sinkFile);
        byte[] buffer = new byte[100];
        int count = is.read(buffer);
        AbstractContentReadWriteTest.assertEquals((String)"No content read", (int)3, (int)count);
        is.close();
        String check = new String(buffer, 0, count);
        AbstractContentReadWriteTest.assertEquals((String)"Write out of and read into files failed", (String)content, (String)check);
    }

    public void testReadAndWriteStreamByPull() throws Exception {
        ContentReader reader = this.getReader();
        ContentWriter writer = this.getWriter();
        String content = "ABC";
        ByteArrayInputStream is = new ByteArrayInputStream(content.getBytes());
        writer.putContent(is);
        AbstractContentReadWriteTest.assertTrue((String)"Stream close not detected", (boolean)writer.isClosed());
        ByteArrayOutputStream os = new ByteArrayOutputStream(100);
        reader.getContent(os);
        byte[] bytes = os.toByteArray();
        String check = new String(bytes);
        AbstractContentReadWriteTest.assertEquals((String)"Write out and read in using streams failed", (String)content, (String)check);
    }

    public void testReadAndWriteStreamByPush() throws Exception {
        ContentReader reader = this.getReader();
        ContentWriter writer = this.getWriter();
        String content = "ABC";
        OutputStream os = writer.getContentOutputStream();
        os.write(content.getBytes());
        AbstractContentReadWriteTest.assertFalse((String)"Stream has not been closed", (boolean)writer.isClosed());
        os.close();
        AbstractContentReadWriteTest.assertTrue((String)"Stream close not detected", (boolean)writer.isClosed());
        InputStream is = reader.getContentInputStream();
        byte[] buffer = new byte[100];
        int count = is.read(buffer);
        AbstractContentReadWriteTest.assertEquals((String)"No content read", (int)3, (int)count);
        is.close();
        String check = new String(buffer, 0, count);
        AbstractContentReadWriteTest.assertEquals((String)"Write out of and read into files failed", (String)content, (String)check);
    }

    public void testDelete() throws Exception {
        ContentStore store = this.getStore();
        ContentWriter writer = this.getWriter();
        String content = "ABC";
        String contentUrl = writer.getContentUrl();
        OutputStream os = writer.getContentOutputStream();
        os.write(content.getBytes());
        os.flush();
        os.close();
        ContentReader reader = store.getReader(contentUrl);
        AbstractContentReadWriteTest.assertNotNull((Object)reader);
        ContentReader readerCheck = writer.getReader();
        AbstractContentReadWriteTest.assertNotNull((Object)readerCheck);
        AbstractContentReadWriteTest.assertEquals((String)"Store and write provided readers onto different URLs", (String)writer.getContentUrl(), (String)reader.getContentUrl());
        InputStream is = reader.getContentInputStream();
        boolean deleted = store.delete(contentUrl);
        is.close();
        reader = store.getReader(contentUrl);
        AbstractContentReadWriteTest.assertNotNull((Object)reader);
        if (deleted) {
            AbstractContentReadWriteTest.assertFalse((String)"Content should not exist", (boolean)reader.exists());
            return;
        }
        AbstractContentReadWriteTest.assertTrue((String)"Content should exist", (boolean)reader.exists());
        store.delete(contentUrl);
        try {
            is = reader.getContentInputStream();
            AbstractContentReadWriteTest.fail((String)"Reader failed to detect underlying content deletion");
        }
        catch (ContentIOException e) {
            // empty catch block
        }
        reader = store.getReader(contentUrl);
        AbstractContentReadWriteTest.assertNotNull((String)"Reader must be returned even when underlying content is missing", (Object)reader);
        AbstractContentReadWriteTest.assertFalse((String)"Content should not exist", (boolean)reader.exists());
        try {
            is = reader.getContentInputStream();
            AbstractContentReadWriteTest.fail((String)"Reader opened stream onto missing content");
        }
        catch (ContentIOException e) {
            // empty catch block
        }
    }

    public void testListUrls() throws Exception {
        ContentStore store = this.getStore();
        ContentWriter writer = this.getWriter();
        Set<String> contentUrls = store.getUrls();
        String contentUrl = writer.getContentUrl();
        AbstractContentReadWriteTest.assertTrue((String)"Writer URL not listed by store", (boolean)contentUrls.contains(contentUrl));
        Date yesterday = new Date(System.currentTimeMillis() - 86400000L);
        writer.putContent("The quick brown fox...");
        contentUrls = store.getUrls();
        AbstractContentReadWriteTest.assertTrue((String)"Writer URL not listed by store", (boolean)contentUrls.contains(contentUrl));
        contentUrls = store.getUrls(null, yesterday);
        AbstractContentReadWriteTest.assertFalse((String)"URL was younger than required, but still shows up", (boolean)contentUrls.contains(contentUrl));
        boolean deleted = store.delete(contentUrl);
        if (deleted) {
            contentUrls = store.getUrls();
            AbstractContentReadWriteTest.assertFalse((String)"Successfully deleted URL still shown by store", (boolean)contentUrls.contains(contentUrl));
        }
    }

    public void testRandomAccessWrite() throws Exception {
        ContentWriter writer = this.getWriter();
        FileChannel fileChannel = writer.getFileChannel(true);
        AbstractContentReadWriteTest.assertNotNull((String)"No channel given", (Object)fileChannel);
        try {
            writer.getWritableChannel();
            AbstractContentReadWriteTest.fail((String)"Second channel access allowed");
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        byte[] content = new byte[]{1, 2, 3};
        for (int i = content.length - 1; i >= 0; --i) {
            ByteBuffer buffer = ByteBuffer.wrap(content, i, 1);
            fileChannel.write(buffer, i);
        }
        fileChannel.close();
        AbstractContentReadWriteTest.assertTrue((String)"Writer not closed", (boolean)writer.isClosed());
        ContentReader reader = writer.getReader();
        ReadableByteChannel channelReader = reader.getReadableChannel();
        ByteBuffer buffer = ByteBuffer.allocateDirect(3);
        int count = channelReader.read(buffer);
        AbstractContentReadWriteTest.assertEquals((String)"Incorrect number of bytes read", (int)3, (int)count);
        for (int i = 0; i < content.length; ++i) {
            AbstractContentReadWriteTest.assertEquals((String)"Content doesn't match", (byte)content[i], (byte)buffer.get(i));
        }
        ContentWriter writerTruncate = this.getStore().getWriter(writer.getReader(), AbstractContentStore.createNewUrl());
        AbstractContentReadWriteTest.assertEquals((String)"Content size incorrect", (long)0L, (long)writerTruncate.getSize());
        FileChannel fcTruncate = writerTruncate.getFileChannel(true);
        fcTruncate.close();
        AbstractContentReadWriteTest.assertEquals((String)"Content not truncated", (long)0L, (long)writerTruncate.getSize());
        ContentWriter writerNoTruncate = this.getStore().getWriter(writer.getReader(), AbstractContentStore.createNewUrl());
        AbstractContentReadWriteTest.assertEquals((String)"Content size incorrect", (long)0L, (long)writerNoTruncate.getSize());
        FileChannel fcNoTruncate = writerNoTruncate.getFileChannel(false);
        fcNoTruncate.close();
        AbstractContentReadWriteTest.assertEquals((String)"Content was truncated", (long)writer.getSize(), (long)writerNoTruncate.getSize());
    }

    public void testRandomAccessRead() throws Exception {
        ContentWriter writer = this.getWriter();
        String content = "ABC";
        byte[] bytes = content.getBytes();
        writer.putContent(content);
        ContentReader reader = writer.getReader();
        FileChannel fileChannel = reader.getFileChannel();
        AbstractContentReadWriteTest.assertNotNull((String)"No channel given", (Object)fileChannel);
        try {
            reader.getReadableChannel();
            AbstractContentReadWriteTest.fail((String)"Second channel access allowed");
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        ByteBuffer buffer = ByteBuffer.allocate(bytes.length);
        int count = fileChannel.read(buffer);
        AbstractContentReadWriteTest.assertEquals((String)"Incorrect number of bytes read", (int)bytes.length, (int)count);
        buffer.rewind();
        buffer.get(bytes);
        String checkContent = new String(bytes);
        AbstractContentReadWriteTest.assertEquals((String)"Content read failure", (String)content, (String)checkContent);
        fileChannel.close();
    }
}

