/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.List;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.content.AbstractContentAccessor;
import org.alfresco.repo.content.filestore.FileContentWriter;
import org.alfresco.service.cmr.repository.ContentIOException;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentStreamListener;
import org.alfresco.util.TempFileProvider;
import org.aopalliance.aop.Advice;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.util.FileCopyUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractContentReader
extends AbstractContentAccessor
implements ContentReader {
    private static final Log logger = LogFactory.getLog(AbstractContentReader.class);
    private List<ContentStreamListener> listeners = new ArrayList<ContentStreamListener>(2);
    private ReadableByteChannel channel;

    protected AbstractContentReader(String contentUrl) {
        super(contentUrl);
    }

    @Override
    public synchronized void addListener(ContentStreamListener listener) {
        if (this.channel != null) {
            throw new RuntimeException("Channel is already in use");
        }
        this.listeners.add(listener);
    }

    protected abstract ContentReader createReader() throws ContentIOException;

    @Override
    public final ContentReader getReader() throws ContentIOException {
        ContentReader reader = this.createReader();
        if (reader == null) {
            throw new AlfrescoRuntimeException("ContentReader failed to create new reader: \n   reader: " + this);
        }
        if (reader.getContentUrl() == null || !reader.getContentUrl().equals(this.getContentUrl())) {
            throw new AlfrescoRuntimeException("ContentReader has different URL: \n   reader: " + this + "\n" + "   new reader: " + reader);
        }
        reader.setMimetype(this.getMimetype());
        reader.setEncoding(this.getEncoding());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Reader spawned new reader: \n   reader: " + this + "\n" + "   new reader: " + reader));
        }
        return reader;
    }

    @Override
    public final synchronized boolean isClosed() {
        if (this.channel != null) {
            return !this.channel.isOpen();
        }
        return false;
    }

    @Override
    protected boolean isChannelOpen() {
        if (this.channel != null) {
            return this.channel.isOpen();
        }
        return false;
    }

    protected abstract ReadableByteChannel getDirectReadableChannel() throws ContentIOException;

    private ReadableByteChannel getCallbackReadableChannel(ReadableByteChannel directChannel, List<ContentStreamListener> listeners) throws ContentIOException {
        ReadableByteChannel callbackChannel = null;
        if (directChannel instanceof FileChannel) {
            callbackChannel = this.getCallbackFileChannel((FileChannel)directChannel, listeners);
        } else {
            AbstractContentAccessor.ChannelCloseCallbackAdvise advise = new AbstractContentAccessor.ChannelCloseCallbackAdvise(listeners);
            ProxyFactory proxyFactory = new ProxyFactory((Object)directChannel);
            proxyFactory.addAdvice((Advice)advise);
            callbackChannel = (ReadableByteChannel)proxyFactory.getProxy();
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Created callback byte channel: \n   original: " + directChannel + "\n" + "   new: " + callbackChannel));
        }
        return callbackChannel;
    }

    @Override
    public final synchronized ReadableByteChannel getReadableChannel() throws ContentIOException {
        if (this.channel != null) {
            throw new RuntimeException("A channel has already been opened");
        }
        ReadableByteChannel directChannel = this.getDirectReadableChannel();
        this.channel = this.getCallbackReadableChannel(directChannel, this.listeners);
        super.channelOpened();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Opened channel onto content: " + this));
        }
        return this.channel;
    }

    @Override
    public FileChannel getFileChannel() throws ContentIOException {
        this.channel = this.getReadableChannel();
        FileChannel clientFileChannel = null;
        if (this.channel instanceof FileChannel) {
            clientFileChannel = (FileChannel)this.channel;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Content reader provided direct support for FileChannel: \n   reader: " + this));
            }
        } else {
            File tempFile = TempFileProvider.createTempFile((String)"random_read_spoof_", (String)".bin");
            FileContentWriter spoofWriter = new FileContentWriter(tempFile);
            FileChannel spoofWriterChannel = spoofWriter.getFileChannel(false);
            try {
                long spoofFileSize = this.getSize();
                spoofWriterChannel.transferFrom(this.channel, 0L, spoofFileSize);
            }
            catch (IOException e) {
                throw new ContentIOException("Failed to copy from permanent channel to spoofed temporary channel: \n   reader: " + this + "\n" + "   temp: " + spoofWriter, e);
            }
            finally {
                try {
                    spoofWriterChannel.close();
                }
                catch (IOException e) {}
            }
            ContentReader spoofReader = spoofWriter.getReader();
            ContentStreamListener spoofListener = new ContentStreamListener(){

                public void contentStreamClosed() throws ContentIOException {
                    try {
                        AbstractContentReader.this.channel.close();
                    }
                    catch (IOException e) {
                        throw new ContentIOException("Failed to close underlying channel", e);
                    }
                }
            };
            spoofReader.addListener(spoofListener);
            clientFileChannel = spoofReader.getFileChannel();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Content writer provided indirect support for FileChannel: \n   writer: " + this + "\n" + "   temp writer: " + spoofWriter));
            }
        }
        return clientFileChannel;
    }

    @Override
    public InputStream getContentInputStream() throws ContentIOException {
        try {
            ReadableByteChannel channel = this.getReadableChannel();
            BufferedInputStream is = new BufferedInputStream(Channels.newInputStream(channel));
            return is;
        }
        catch (Throwable e) {
            throw new ContentIOException("Failed to open stream onto channel: \n   accessor: " + this, e);
        }
    }

    @Override
    public final void getContent(OutputStream os) throws ContentIOException {
        try {
            InputStream is = this.getContentInputStream();
            FileCopyUtils.copy((InputStream)is, (OutputStream)os);
        }
        catch (IOException e) {
            throw new ContentIOException("Failed to copy content to output stream: \n   accessor: " + this, e);
        }
    }

    @Override
    public final void getContent(File file) throws ContentIOException {
        try {
            InputStream is = this.getContentInputStream();
            FileOutputStream os = new FileOutputStream(file);
            FileCopyUtils.copy((InputStream)is, (OutputStream)os);
        }
        catch (IOException e) {
            throw new ContentIOException("Failed to copy content to file: \n   accessor: " + this + "\n" + "   file: " + file, e);
        }
    }

    @Override
    public final String getContentString(int length) throws ContentIOException {
        if (length < 0 || length > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Character count must be positive and within range");
        }
        Reader reader = null;
        try {
            String result;
            char[] buffer = new char[length];
            String encoding = this.getEncoding();
            reader = encoding == null ? new InputStreamReader(this.getContentInputStream()) : new InputStreamReader(this.getContentInputStream(), encoding);
            int count = reader.read(buffer, 0, length);
            String string = result = new String(buffer, 0, count);
            return string;
        }
        catch (IOException e) {
            throw new ContentIOException("Failed to copy content to string: \n   accessor: " + this + "\n" + "   length: " + length, e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Throwable e) {
                    logger.error((Object)e);
                }
            }
        }
    }

    @Override
    public final String getContentString() throws ContentIOException {
        try {
            InputStream is = this.getContentInputStream();
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            FileCopyUtils.copy((InputStream)is, (OutputStream)os);
            byte[] bytes = os.toByteArray();
            String encoding = this.getEncoding();
            String content = encoding == null ? new String(bytes) : new String(bytes, encoding);
            return content;
        }
        catch (IOException e) {
            throw new ContentIOException("Failed to copy content to string: \n   accessor: " + this, e);
        }
    }
}

