/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content;

import java.util.GregorianCalendar;
import java.util.Set;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.content.ContentStore;
import org.alfresco.service.cmr.repository.ContentIOException;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.util.GUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractContentStore
implements ContentStore {
    @Override
    public boolean exists(String contentUrl) throws ContentIOException {
        ContentReader reader = this.getReader(contentUrl);
        return reader.exists();
    }

    public static String createNewUrl() {
        GregorianCalendar calendar = new GregorianCalendar();
        int year = calendar.get(1);
        int month = calendar.get(2) + 1;
        int day = calendar.get(5);
        int hour = calendar.get(11);
        int minute = calendar.get(12);
        StringBuilder sb = new StringBuilder(20);
        sb.append("store://").append(year).append('/').append(month).append('/').append(day).append('/').append(hour).append('/').append(minute).append('/').append(GUID.generate()).append(".bin");
        String newContentUrl = sb.toString();
        return newContentUrl;
    }

    public static String getRelativePart(String contentUrl) throws RuntimeException {
        int index = 0;
        if (contentUrl.startsWith("store://")) {
            index = 8;
        } else if (contentUrl.startsWith("file://")) {
            index = 7;
        } else {
            throw new AlfrescoRuntimeException("All content URLs must start with store://: \n   the invalid url is: " + contentUrl);
        }
        String path = contentUrl.substring(index);
        if (path.length() < 10) {
            throw new AlfrescoRuntimeException("The content URL is invalid: \n   content url: " + contentUrl);
        }
        return path;
    }

    @Override
    public final Set<String> getUrls() throws ContentIOException {
        return this.getUrls(null, null);
    }
}

