/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content;

import java.util.Map;
import org.alfresco.repo.content.MimetypeMap;
import org.alfresco.util.BaseSpringTest;

public class MimetypeMapTest
extends BaseSpringTest {
    private MimetypeMap mimetypeMap;

    public void setMimetypeMap(MimetypeMap mimetypeMap) {
        this.mimetypeMap = mimetypeMap;
    }

    public void testExtensions() throws Exception {
        Map<String, String> extensionsByMimetype = this.mimetypeMap.getExtensionsByMimetype();
        Map<String, String> mimetypesByExtension = this.mimetypeMap.getMimetypesByExtension();
        MimetypeMapTest.assertEquals((String)"txt", (String)extensionsByMimetype.get("text/plain"));
        MimetypeMapTest.assertEquals((String)"text/plain", (String)mimetypesByExtension.get("txt"));
        MimetypeMapTest.assertEquals((String)"text/plain", (String)mimetypesByExtension.get("csv"));
        MimetypeMapTest.assertEquals((String)"text/plain", (String)mimetypesByExtension.get("java"));
        MimetypeMapTest.assertEquals((String)"jpg", (String)extensionsByMimetype.get("image/jpeg"));
        MimetypeMapTest.assertEquals((String)"image/jpeg", (String)mimetypesByExtension.get("jpg"));
        MimetypeMapTest.assertEquals((String)"image/jpeg", (String)mimetypesByExtension.get("jpeg"));
        MimetypeMapTest.assertEquals((String)"image/jpeg", (String)mimetypesByExtension.get("jpe"));
        MimetypeMapTest.assertEquals((String)"doc", (String)extensionsByMimetype.get("application/msword"));
        MimetypeMapTest.assertEquals((String)"application/msword", (String)mimetypesByExtension.get("doc"));
        MimetypeMapTest.assertEquals((String)"sds", (String)extensionsByMimetype.get("application/vnd.stardivision.chart"));
    }
}

