/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.content.ContentServicePolicies;
import org.alfresco.repo.content.ContentStore;
import org.alfresco.repo.content.filestore.FileContentStore;
import org.alfresco.repo.content.transform.ContentTransformer;
import org.alfresco.repo.content.transform.ContentTransformerRegistry;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.ClassPolicyDelegate;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.InvalidTypeException;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.ContentIOException;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentStreamListener;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NoTransformerException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.EqualsHelper;
import org.alfresco.util.TempFileProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RoutingContentService
implements ContentService {
    private static Log logger = LogFactory.getLog(RoutingContentService.class);
    private TransactionService transactionService;
    private DictionaryService dictionaryService;
    private NodeService nodeService;
    private ContentTransformerRegistry transformerRegistry;
    private ContentStore store;
    private ContentStore tempStore = new FileContentStore(TempFileProvider.getTempDir().getAbsolutePath());
    private PolicyComponent policyComponent;
    ClassPolicyDelegate<ContentServicePolicies.OnContentUpdatePolicy> onContentUpdateDelegate;
    ClassPolicyDelegate<ContentServicePolicies.OnContentReadPolicy> onContentReadDelegate;

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setTransformerRegistry(ContentTransformerRegistry transformerRegistry) {
        this.transformerRegistry = transformerRegistry;
    }

    public void setStore(ContentStore store) {
        this.store = store;
    }

    public void setPolicyComponent(PolicyComponent policyComponent) {
        this.policyComponent = policyComponent;
    }

    public void init() {
        this.policyComponent.bindClassBehaviour(QName.createQName("http://www.alfresco.org", "onUpdateProperties"), this, (Behaviour)new JavaBehaviour(this, "onUpdateProperties"));
        this.onContentUpdateDelegate = this.policyComponent.registerClassPolicy(ContentServicePolicies.OnContentUpdatePolicy.class);
        this.onContentReadDelegate = this.policyComponent.registerClassPolicy(ContentServicePolicies.OnContentReadPolicy.class);
    }

    public void onUpdateProperties(NodeRef nodeRef, Map<QName, Serializable> before, Map<QName, Serializable> after) {
        boolean fire = false;
        boolean newContent = false;
        for (QName propertyQName : after.keySet()) {
            PropertyDefinition propertyDef = this.dictionaryService.getProperty(propertyQName);
            if (propertyDef == null || !propertyDef.getDataType().getName().equals(DataTypeDefinition.CONTENT)) continue;
            try {
                ContentData beforeValue = (ContentData)before.get(propertyQName);
                ContentData afterValue = (ContentData)after.get(propertyQName);
                if (afterValue != null && afterValue.getContentUrl() == null || EqualsHelper.nullSafeEquals((Object)beforeValue, (Object)afterValue)) continue;
                if (logger.isDebugEnabled()) {
                    String beforeString = "";
                    if (beforeValue != null) {
                        beforeString = beforeValue.toString();
                    }
                    String afterString = "";
                    if (afterValue != null) {
                        afterString = afterValue.toString();
                    }
                    logger.debug((Object)("onContentUpate: before = " + beforeString + "; after = " + afterString));
                }
                String beforeContentUrl = null;
                if (beforeValue != null) {
                    beforeContentUrl = beforeValue.getContentUrl();
                }
                String afterContentUrl = null;
                if (afterValue != null) {
                    afterContentUrl = afterValue.getContentUrl();
                }
                if (beforeContentUrl == null && afterContentUrl != null) {
                    newContent = true;
                }
                fire = true;
                break;
            }
            catch (ClassCastException e) {
            }
        }
        if (fire) {
            HashSet<QName> types = new HashSet<QName>(this.nodeService.getAspects(nodeRef));
            types.add(this.nodeService.getType(nodeRef));
            ContentServicePolicies.OnContentUpdatePolicy policy = this.onContentUpdateDelegate.get(nodeRef, types);
            policy.onContentUpdate(nodeRef, newContent);
        }
    }

    @Override
    public ContentReader getReader(NodeRef nodeRef, QName propertyQName) {
        return this.getReader(nodeRef, propertyQName, true);
    }

    private ContentReader getReader(NodeRef nodeRef, QName propertyQName, boolean fireContentReadPolicy) {
        PropertyDefinition contentPropDef;
        Collection colPropValue;
        ContentData contentData = null;
        Serializable propValue = this.nodeService.getProperty(nodeRef, propertyQName);
        if (propValue instanceof Collection && (colPropValue = (Collection)((Object)propValue)).size() > 0) {
            propValue = (Serializable)colPropValue.iterator().next();
        }
        if (propValue instanceof ContentData) {
            contentData = (ContentData)propValue;
        }
        if (contentData == null && (contentPropDef = this.dictionaryService.getProperty(propertyQName)) != null && !contentPropDef.getDataType().getName().equals(DataTypeDefinition.CONTENT) && !contentPropDef.getDataType().getName().equals(DataTypeDefinition.ANY)) {
            throw new InvalidTypeException("The node property must be of type content: \n   node: " + nodeRef + "\n" + "   property name: " + propertyQName + "\n" + "   property type: " + (contentPropDef == null ? "unknown" : contentPropDef.getDataType()), propertyQName);
        }
        if (contentData == null || contentData.getContentUrl() == null) {
            return null;
        }
        String contentUrl = contentData.getContentUrl();
        ContentReader reader = this.store.getReader(contentUrl);
        reader.setMimetype(contentData.getMimetype());
        reader.setEncoding(contentData.getEncoding());
        if (reader != null && fireContentReadPolicy) {
            HashSet<QName> types = new HashSet<QName>(this.nodeService.getAspects(nodeRef));
            types.add(this.nodeService.getType(nodeRef));
            ContentServicePolicies.OnContentReadPolicy policy = this.onContentReadDelegate.get(nodeRef, types);
            policy.onContentRead(nodeRef);
        }
        return reader;
    }

    @Override
    public ContentWriter getWriter(NodeRef nodeRef, QName propertyQName, boolean update) {
        ContentReader existingContentReader = this.getReader(nodeRef, propertyQName, false);
        ContentWriter writer = this.store.getWriter(existingContentReader, null);
        Serializable contentValue = this.nodeService.getProperty(nodeRef, propertyQName);
        if (contentValue != null && contentValue instanceof ContentData) {
            ContentData contentData = (ContentData)contentValue;
            writer.setMimetype(contentData.getMimetype());
            writer.setEncoding(contentData.getEncoding());
        }
        if (update) {
            WriteStreamListener listener = new WriteStreamListener(this.nodeService, nodeRef, propertyQName, writer);
            writer.addListener(listener);
            writer.setTransactionService(this.transactionService);
        }
        return writer;
    }

    @Override
    public ContentWriter getTempWriter() {
        return this.tempStore.getWriter(null, null);
    }

    @Override
    public void transform(ContentReader reader, ContentWriter writer) throws NoTransformerException, ContentIOException {
        String sourceMimetype = reader.getMimetype();
        if (sourceMimetype == null) {
            throw new AlfrescoRuntimeException("The content reader mimetype must be set: " + reader);
        }
        String targetMimetype = writer.getMimetype();
        if (targetMimetype == null) {
            throw new AlfrescoRuntimeException("The content writer mimetype must be set: " + writer);
        }
        ContentTransformer transformer = this.transformerRegistry.getTransformer(sourceMimetype, targetMimetype);
        if (transformer == null) {
            throw new NoTransformerException(sourceMimetype, targetMimetype);
        }
        transformer.transform(reader, writer);
    }

    @Override
    public ContentTransformer getTransformer(String sourceMimetype, String targetMimetype) {
        ContentTransformer transformer = this.transformerRegistry.getTransformer(sourceMimetype, targetMimetype);
        return transformer;
    }

    @Override
    public boolean isTransformable(ContentReader reader, ContentWriter writer) {
        String sourceMimetype = reader.getMimetype();
        if (sourceMimetype == null) {
            throw new AlfrescoRuntimeException("The content reader mimetype must be set: " + reader);
        }
        String targetMimetype = writer.getMimetype();
        if (targetMimetype == null) {
            throw new AlfrescoRuntimeException("The content writer mimetype must be set: " + writer);
        }
        ContentTransformer transformer = this.transformerRegistry.getTransformer(sourceMimetype, targetMimetype);
        return transformer != null;
    }

    private static class WriteStreamListener
    implements ContentStreamListener {
        private NodeService nodeService;
        private NodeRef nodeRef;
        private QName propertyQName;
        private ContentWriter writer;

        public WriteStreamListener(NodeService nodeService, NodeRef nodeRef, QName propertyQName, ContentWriter writer) {
            this.nodeService = nodeService;
            this.nodeRef = nodeRef;
            this.propertyQName = propertyQName;
            this.writer = writer;
        }

        public void contentStreamClosed() throws ContentIOException {
            try {
                ContentData contentData = this.writer.getContentData();
                this.nodeService.setProperty(this.nodeRef, this.propertyQName, contentData);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Stream listener updated node: \n   node: " + this.nodeRef + "\n" + "   property: " + this.propertyQName + "\n" + "   value: " + contentData));
                }
            }
            catch (Throwable e) {
                throw new ContentIOException("Failed to set content property on stream closure: \n   node: " + this.nodeRef + "\n" + "   property: " + this.propertyQName + "\n" + "   writer: " + this.writer, e);
            }
        }
    }
}

