/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import javax.transaction.RollbackException;
import javax.transaction.UserTransaction;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.content.filestore.FileContentWriter;
import org.alfresco.repo.content.transform.ContentTransformer;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.ContentIOException;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NoTransformerException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.BaseSpringTest;
import org.alfresco.util.GUID;
import org.alfresco.util.PropertyMap;
import org.alfresco.util.TempFileProvider;

public class RoutingContentServiceTest
extends BaseSpringTest {
    private static final String SOME_CONTENT = "ABC";
    private static final String TEST_NAMESPACE = "http://www.alfresco.org/test/RoutingContentServiceTest";
    private ContentService contentService;
    private PolicyComponent policyComponent;
    private NodeService nodeService;
    private NodeRef rootNodeRef;
    private NodeRef contentNodeRef;
    private AuthenticationComponent authenticationComponent;
    private boolean policyFired = false;
    private boolean readPolicyFired = false;
    private boolean newContent = true;

    public void onSetUpInTransaction() throws Exception {
        super.onSetUpInTransaction();
        this.nodeService = (NodeService)this.applicationContext.getBean("dbNodeService");
        this.contentService = (ContentService)this.applicationContext.getBean(ServiceRegistry.CONTENT_SERVICE.getLocalName());
        this.policyComponent = (PolicyComponent)this.applicationContext.getBean("policyComponent");
        this.authenticationComponent = (AuthenticationComponent)this.applicationContext.getBean("authenticationComponent");
        this.authenticationComponent.setSystemUserAsCurrentUser();
        StoreRef storeRef = new StoreRef("workspace", this.getName());
        if (!this.nodeService.exists(storeRef)) {
            storeRef = this.nodeService.createStore(storeRef.getProtocol(), storeRef.getIdentifier());
        }
        this.rootNodeRef = this.nodeService.getRootNode(storeRef);
        ContentData contentData = new ContentData(null, "text/plain", 0L, "UTF-16");
        PropertyMap properties = new PropertyMap();
        properties.put(ContentModel.PROP_CONTENT, contentData);
        ChildAssociationRef assocRef = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName(TEST_NAMESPACE, GUID.generate()), ContentModel.TYPE_CONTENT, properties);
        this.contentNodeRef = assocRef.getChildRef();
    }

    protected void onTearDownInTransaction() throws Exception {
        try {
            this.authenticationComponent.clearCurrentSecurityContext();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        super.onTearDownInTransaction();
    }

    private UserTransaction getUserTransaction() {
        TransactionService transactionService = (TransactionService)this.applicationContext.getBean("transactionComponent");
        return transactionService.getUserTransaction();
    }

    public void testSetUp() throws Exception {
        RoutingContentServiceTest.assertNotNull((Object)this.contentService);
        RoutingContentServiceTest.assertNotNull((Object)this.nodeService);
        RoutingContentServiceTest.assertNotNull((Object)this.rootNodeRef);
        RoutingContentServiceTest.assertNotNull((Object)this.contentNodeRef);
        RoutingContentServiceTest.assertNotNull((Object)this.getUserTransaction());
        RoutingContentServiceTest.assertFalse((this.getUserTransaction() == this.getUserTransaction() ? 1 : 0) != 0);
    }

    public void testAutoSettingOfProperties() throws Exception {
        ContentWriter writer = this.contentService.getWriter(this.contentNodeRef, ContentModel.PROP_CONTENT, true);
        RoutingContentServiceTest.assertNotNull((String)"Writer should not be null", (Object)writer);
        RoutingContentServiceTest.assertNotNull((String)"Content URL should not be null", (Object)writer.getContentUrl());
        RoutingContentServiceTest.assertNotNull((String)"Content mimetype should not be null", (Object)writer.getMimetype());
        RoutingContentServiceTest.assertNotNull((String)"Content encoding should not be null", (Object)writer.getEncoding());
        writer.putContent(SOME_CONTENT);
        ContentReader reader = this.contentService.getReader(this.contentNodeRef, ContentModel.PROP_CONTENT);
        RoutingContentServiceTest.assertNotNull((String)"Reader should not be null", (Object)reader);
        RoutingContentServiceTest.assertNotNull((String)"Content URL should not be null", (Object)reader.getContentUrl());
        RoutingContentServiceTest.assertNotNull((String)"Content mimetype should not be null", (Object)reader.getMimetype());
        RoutingContentServiceTest.assertNotNull((String)"Content encoding should not be null", (Object)reader.getEncoding());
        long length = SOME_CONTENT.getBytes(reader.getEncoding()).length;
        long checkLength = reader.getSize();
        RoutingContentServiceTest.assertEquals((String)"Content length incorrect", (long)length, (long)checkLength);
        String contentCheck = reader.getContentString();
        RoutingContentServiceTest.assertEquals((String)"Content incorrect", (String)SOME_CONTENT, (String)contentCheck);
    }

    public void testWriteToNodeWithoutAnyContentProperties() throws Exception {
        ContentWriter writer = this.contentService.getWriter(this.contentNodeRef, ContentModel.PROP_CONTENT, true);
        RoutingContentServiceTest.assertNotNull((Object)writer.getMimetype());
        RoutingContentServiceTest.assertNotNull((Object)writer.getEncoding());
        this.nodeService.setProperty(this.contentNodeRef, ContentModel.PROP_CONTENT, null);
        writer = this.contentService.getWriter(this.contentNodeRef, ContentModel.PROP_CONTENT, true);
        RoutingContentServiceTest.assertNull((Object)writer.getMimetype());
        RoutingContentServiceTest.assertEquals((String)"UTF-8", (String)writer.getEncoding());
        writer.setMimetype("text/plain");
        writer.setEncoding("UTF-8");
        String content = "The quick brown fox ...";
        writer.putContent(content);
        ContentData contentData = (ContentData)this.nodeService.getProperty(this.contentNodeRef, ContentModel.PROP_CONTENT);
        RoutingContentServiceTest.assertEquals((String)"metadata didn't get onto node", (Object)writer.getContentData(), (Object)contentData);
        ContentReader reader = this.contentService.getReader(this.contentNodeRef, ContentModel.PROP_CONTENT);
        RoutingContentServiceTest.assertEquals((String)"Metadata didn't get set on reader", (Object)writer.getContentData(), (Object)reader.getContentData());
    }

    public void testNullReaderForNullUrl() throws Exception {
        ContentData contentData = new ContentData(null, null, 0L, null);
        this.nodeService.setProperty(this.contentNodeRef, ContentModel.PROP_CONTENT, contentData);
        ContentReader reader = this.contentService.getReader(this.contentNodeRef, ContentModel.PROP_CONTENT);
        RoutingContentServiceTest.assertNull((String)"Reader must be null if the content URL is null", (Object)reader);
    }

    public void testMissingContent() throws Exception {
        File tempFile = TempFileProvider.createTempFile((String)this.getName(), (String)".txt");
        FileContentWriter writer = new FileContentWriter(tempFile);
        writer.setMimetype("text/plain");
        writer.setEncoding("UTF-8");
        writer.putContent("What about the others?  Buckwheats!");
        RoutingContentServiceTest.assertTrue((String)"File does not exist", (boolean)tempFile.exists());
        RoutingContentServiceTest.assertTrue((String)"File not written to", (tempFile.length() > 0L ? 1 : 0) != 0);
        ContentData contentData = writer.getContentData();
        this.nodeService.setProperty(this.contentNodeRef, ContentModel.PROP_CONTENT, contentData);
        tempFile.delete();
        RoutingContentServiceTest.assertFalse((String)"File not deleted", (boolean)tempFile.exists());
        ContentReader reader = this.contentService.getReader(this.contentNodeRef, ContentModel.PROP_CONTENT);
        RoutingContentServiceTest.assertFalse((String)"Reader should indicate that content is missing", (boolean)reader.exists());
        this.setComplete();
        this.endTransaction();
    }

    public void testSimpleWrite() throws Exception {
        ContentWriter writer = this.contentService.getWriter(this.contentNodeRef, ContentModel.PROP_CONTENT, false);
        RoutingContentServiceTest.assertNotNull((String)"Writer should not be null", (Object)writer);
        writer.putContent(SOME_CONTENT);
        ContentReader reader = this.contentService.getReader(this.contentNodeRef, ContentModel.PROP_CONTENT);
        RoutingContentServiceTest.assertNull((String)"No reader should yet be available for the node", (Object)reader);
    }

    public void testOnContentUpdatePolicy() {
        this.policyComponent.bindClassBehaviour(QName.createQName("http://www.alfresco.org", "onContentUpdate"), ContentModel.ASPECT_VERSIONABLE, (Behaviour)new JavaBehaviour((Object)this, "onContentUpdateBehaviourTest"));
        ContentWriter contentWriter = this.contentService.getWriter(this.contentNodeRef, ContentModel.PROP_CONTENT, true);
        contentWriter.putContent("content update one");
        RoutingContentServiceTest.assertFalse((boolean)this.policyFired);
        this.newContent = false;
        this.nodeService.addAspect(this.contentNodeRef, ContentModel.ASPECT_VERSIONABLE, null);
        ContentWriter contentWriter2 = this.contentService.getWriter(this.contentNodeRef, ContentModel.PROP_CONTENT, true);
        contentWriter2.putContent("content update two");
        RoutingContentServiceTest.assertTrue((boolean)this.policyFired);
        this.policyFired = false;
        ContentWriter contentWriter3 = this.contentService.getWriter(this.contentNodeRef, ContentModel.PROP_CONTENT, false);
        contentWriter3.putContent("content update three");
        RoutingContentServiceTest.assertFalse((boolean)this.policyFired);
    }

    public void onContentUpdateBehaviourTest(NodeRef nodeRef, boolean newContent) {
        RoutingContentServiceTest.assertEquals((Object)this.contentNodeRef, (Object)nodeRef);
        RoutingContentServiceTest.assertEquals((boolean)this.newContent, (boolean)newContent);
        RoutingContentServiceTest.assertTrue((boolean)this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_VERSIONABLE));
        this.policyFired = true;
    }

    public void testOnContentReadPolicy() {
        this.policyComponent.bindClassBehaviour(QName.createQName("http://www.alfresco.org", "onContentRead"), ContentModel.ASPECT_VERSIONABLE, (Behaviour)new JavaBehaviour((Object)this, "onContentReadBehaviourTest"));
        this.contentService.getReader(this.contentNodeRef, ContentModel.PROP_CONTENT);
        RoutingContentServiceTest.assertFalse((boolean)this.readPolicyFired);
        ContentWriter contentWriter2 = this.contentService.getWriter(this.contentNodeRef, ContentModel.PROP_CONTENT, true);
        contentWriter2.putContent("content update two");
        this.contentService.getReader(this.contentNodeRef, ContentModel.PROP_CONTENT);
        RoutingContentServiceTest.assertFalse((boolean)this.readPolicyFired);
        this.nodeService.addAspect(this.contentNodeRef, ContentModel.ASPECT_VERSIONABLE, null);
        this.contentService.getReader(this.contentNodeRef, ContentModel.PROP_CONTENT);
        RoutingContentServiceTest.assertTrue((boolean)this.readPolicyFired);
    }

    public void onContentReadBehaviourTest(NodeRef nodeRef) {
        this.readPolicyFired = true;
    }

    public void testTempWrite() throws Exception {
        ContentWriter writer1 = this.contentService.getTempWriter();
        ContentWriter writer2 = this.contentService.getTempWriter();
        RoutingContentServiceTest.assertNotSame((String)"Temp URLs must be different", (Object)writer1.getContentUrl(), (Object)writer2.getContentUrl());
    }

    public void testUpdatingWrite() throws Exception {
        ContentData contentData = (ContentData)this.nodeService.getProperty(this.contentNodeRef, ContentModel.PROP_CONTENT);
        RoutingContentServiceTest.assertNull((String)"Content URL should be null", (Object)contentData.getContentUrl());
        ContentReader reader = this.contentService.getReader(this.contentNodeRef, ContentModel.PROP_CONTENT);
        RoutingContentServiceTest.assertNull((String)"No reader should be available for new node", (Object)reader);
        ContentWriter writer = this.contentService.getWriter(this.contentNodeRef, ContentModel.PROP_CONTENT, true);
        RoutingContentServiceTest.assertNotNull((String)"No writer received", (Object)writer);
        writer.putContent(SOME_CONTENT);
        try {
            writer.putContent("DEF");
            RoutingContentServiceTest.fail((String)"Failed to prevent repeated use of the content writer");
        }
        catch (ContentIOException e) {
            // empty catch block
        }
        reader = this.contentService.getReader(this.contentNodeRef, ContentModel.PROP_CONTENT);
        RoutingContentServiceTest.assertNotNull((String)"No reader available for node", (Object)reader);
        String contentCheck = reader.getContentString();
        RoutingContentServiceTest.assertEquals((String)"Content fetched doesn't match that written", (String)SOME_CONTENT, (String)contentCheck);
        contentData = (ContentData)this.nodeService.getProperty(this.contentNodeRef, ContentModel.PROP_CONTENT);
        RoutingContentServiceTest.assertNotNull((String)"Content data not set", (Object)contentData);
        RoutingContentServiceTest.assertEquals((String)"Mismatched URL between writer and node", (String)writer.getContentUrl(), (String)contentData.getContentUrl());
        RoutingContentServiceTest.assertEquals((String)"Reader content length and node content length different", (long)reader.getSize(), (long)contentData.getSize());
        RoutingContentServiceTest.assertEquals((String)"Mimetype not set on content data", (String)"text/plain", (String)contentData.getMimetype());
        RoutingContentServiceTest.assertEquals((String)"Encoding not set", (String)"UTF-16", (String)contentData.getEncoding());
    }

    public void testConcurrentWritesNoTxn() throws Exception {
        this.setComplete();
        this.endTransaction();
        ContentWriter writer1 = this.contentService.getWriter(this.contentNodeRef, ContentModel.PROP_CONTENT, true);
        ContentWriter writer2 = this.contentService.getWriter(this.contentNodeRef, ContentModel.PROP_CONTENT, true);
        ContentWriter writer3 = this.contentService.getWriter(this.contentNodeRef, ContentModel.PROP_CONTENT, true);
        writer1.putContent("writer1 wrote this");
        writer2.putContent("writer2 wrote this");
        writer3.putContent("writer3 wrote this");
        ContentReader reader = this.contentService.getReader(this.contentNodeRef, ContentModel.PROP_CONTENT);
        String contentCheck = reader.getContentString();
        RoutingContentServiceTest.assertEquals((String)"Content check failed", (String)"writer3 wrote this", (String)contentCheck);
    }

    public void testConcurrentWritesWithSingleTxn() throws Exception {
        this.setComplete();
        this.endTransaction();
        UserTransaction txn = this.getUserTransaction();
        txn.begin();
        txn.setRollbackOnly();
        ContentWriter writer1 = this.contentService.getWriter(this.contentNodeRef, ContentModel.PROP_CONTENT, true);
        ContentWriter writer2 = this.contentService.getWriter(this.contentNodeRef, ContentModel.PROP_CONTENT, true);
        ContentWriter writer3 = this.contentService.getWriter(this.contentNodeRef, ContentModel.PROP_CONTENT, true);
        writer1.putContent("writer1 wrote this");
        writer2.putContent("writer2 wrote this");
        writer3.putContent("writer3 wrote this");
        ContentReader reader = this.contentService.getReader(this.contentNodeRef, ContentModel.PROP_CONTENT);
        String contentCheck = reader.getContentString();
        RoutingContentServiceTest.assertEquals((String)"Content check failed", (String)"writer3 wrote this", (String)contentCheck);
        try {
            txn.commit();
            RoutingContentServiceTest.fail((String)"Transaction has been marked for rollback");
        }
        catch (RollbackException e) {
            // empty catch block
        }
        txn.rollback();
        txn = this.getUserTransaction();
        txn.begin();
        txn.setRollbackOnly();
        reader = this.contentService.getReader(this.contentNodeRef, ContentModel.PROP_CONTENT);
        RoutingContentServiceTest.assertNull((String)"Transaction was rolled back - no content should be visible", (Object)reader);
        txn.rollback();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void testConcurrentWritesWithMultipleTxns() throws Exception {
        this.setComplete();
        this.endTransaction();
        UserTransaction txn = this.getUserTransaction();
        txn.begin();
        ContentReader reader = this.contentService.getReader(this.contentNodeRef, ContentModel.PROP_CONTENT);
        RoutingContentServiceTest.assertNull((String)"Reader should not be available", (Object)reader);
        ContentWriter threadWriter = this.contentService.getWriter(this.contentNodeRef, ContentModel.PROP_CONTENT, true);
        String threadContent = "Thread content";
        WriteThread thread = new WriteThread(threadWriter, threadContent);
        thread.start();
        while (!thread.isWaiting()) {
            ((Object)((Object)this)).wait(10L);
        }
        ContentWriter writer = this.contentService.getWriter(this.contentNodeRef, ContentModel.PROP_CONTENT, true);
        writer.putContent(SOME_CONTENT);
        ContentWriter contentWriter = threadWriter;
        synchronized (contentWriter) {
            threadWriter.notifyAll();
        }
        while (!thread.isDone()) {
            ((Object)((Object)this)).wait(10L);
        }
        reader = this.contentService.getReader(this.contentNodeRef, ContentModel.PROP_CONTENT);
        RoutingContentServiceTest.assertNotNull((String)"Reader should now be available", (Object)reader);
        String checkContent = reader.getContentString();
        RoutingContentServiceTest.assertEquals((String)"Content check failed", (String)SOME_CONTENT, (String)checkContent);
        txn.rollback();
        reader = this.contentService.getReader(this.contentNodeRef, ContentModel.PROP_CONTENT);
        RoutingContentServiceTest.assertNotNull((String)"Reader should now be available", (Object)reader);
        checkContent = reader.getContentString();
        RoutingContentServiceTest.assertEquals((String)"Content check failed", (String)threadContent, (String)checkContent);
    }

    public void testTransformation() throws Exception {
        this.setComplete();
        this.endTransaction();
        UserTransaction txn = this.getUserTransaction();
        txn.begin();
        txn.setRollbackOnly();
        ContentWriter writer = this.contentService.getTempWriter();
        writer.setMimetype("text/xml");
        String content = "<blah></blah>";
        writer.putContent(content);
        ContentReader reader = writer.getReader();
        writer = this.contentService.getTempWriter();
        writer.setMimetype("audio/x-wav");
        try {
            this.contentService.transform(reader, writer);
            RoutingContentServiceTest.fail((String)"Transformation attempted with invalid mimetype");
        }
        catch (NoTransformerException e) {
            // empty catch block
        }
        txn.rollback();
        txn = this.getUserTransaction();
        txn.begin();
        txn.setRollbackOnly();
        writer.setMimetype("text/plain");
        ContentTransformer transformer = this.contentService.getTransformer(reader.getMimetype(), writer.getMimetype());
        RoutingContentServiceTest.assertNotNull((String)"Expected a valid transformer", (Object)transformer);
        this.contentService.transform(reader, writer);
        reader = writer.getReader();
        RoutingContentServiceTest.assertEquals((String)"Mimetype of target reader incorrect", (String)writer.getMimetype(), (String)reader.getMimetype());
        String contentCheck = reader.getContentString();
        RoutingContentServiceTest.assertEquals((String)"Content check failed", (String)content, (String)contentCheck);
        txn.rollback();
    }

    private class WriteThread
    extends Thread {
        private ContentWriter writer;
        private String content;
        private boolean isWaiting;
        private boolean isDone;

        public WriteThread(ContentWriter writer, String content) {
            this.writer = writer;
            this.content = content;
            this.isWaiting = false;
            this.isDone = false;
        }

        public boolean isWaiting() {
            return this.isWaiting;
        }

        public boolean isDone() {
            return this.isDone;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            RoutingContentServiceTest.this.authenticationComponent.setSystemUserAsCurrentUser();
            this.isWaiting = false;
            this.isDone = false;
            UserTransaction txn = RoutingContentServiceTest.this.getUserTransaction();
            OutputStream os = this.writer.getContentOutputStream();
            try {
                txn.begin();
                if (this.writer.getEncoding() == null) {
                    os.write(this.content.getBytes());
                } else {
                    os.write(this.content.getBytes(this.writer.getEncoding()));
                }
                ContentWriter contentWriter = this.writer;
                synchronized (contentWriter) {
                    this.isWaiting = true;
                    this.writer.wait();
                }
                os.close();
                os = null;
                txn.commit();
            }
            catch (Throwable e) {
                try {
                    txn.rollback();
                }
                catch (Exception ee) {
                    // empty catch block
                }
                e.printStackTrace();
                throw new RuntimeException("Failed writing to output stream for writer: " + this.writer, e);
            }
            finally {
                if (os != null) {
                    try {
                        os.close();
                    }
                    catch (IOException e) {}
                }
                this.isDone = true;
            }
        }
    }
}

