/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.cleanup;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.content.ContentStore;
import org.alfresco.repo.content.cleanup.ContentStoreCleanerListener;
import org.alfresco.repo.node.db.NodeDaoService;
import org.alfresco.repo.transaction.TransactionUtil;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.transaction.TransactionService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContentStoreCleaner {
    private static Log logger = LogFactory.getLog(ContentStoreCleaner.class);
    private DictionaryService dictionaryService;
    private NodeDaoService nodeDaoService;
    private TransactionService transactionService;
    private List<ContentStore> stores = new ArrayList<ContentStore>(0);
    private List<ContentStoreCleanerListener> listeners = new ArrayList<ContentStoreCleanerListener>(0);
    private int protectDays = 7;

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setNodeDaoService(NodeDaoService nodeDaoService) {
        this.nodeDaoService = nodeDaoService;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void setStores(List<ContentStore> stores) {
        this.stores = stores;
    }

    public void setListeners(List<ContentStoreCleanerListener> listeners) {
        this.listeners = listeners;
    }

    public void setProtectDays(int protectDays) {
        this.protectDays = protectDays;
    }

    private void checkProperties() {
        if (this.dictionaryService == null) {
            throw new AlfrescoRuntimeException("Property 'dictionaryService' not set");
        }
        if (this.nodeDaoService == null) {
            throw new AlfrescoRuntimeException("Property 'nodeDaoService' not set");
        }
        if (this.transactionService == null) {
            throw new AlfrescoRuntimeException("Property 'transactionService' not set");
        }
        if (this.stores == null || this.stores.size() == 0) {
            throw new AlfrescoRuntimeException("Property 'stores' not set");
        }
        if (this.listeners == null) {
            throw new AlfrescoRuntimeException("Property 'listeners' not set");
        }
        if (this.protectDays < 0) {
            throw new AlfrescoRuntimeException("Property 'protectDays' must be 0 or greater (0 is not recommended)");
        }
        if (this.protectDays == 0) {
            logger.warn((Object)"Property 'protectDays' is set to 0.  It is possible that in-transaction content will be deleted.");
        }
    }

    private Set<String> getValidUrls() {
        TransactionUtil.TransactionWork<List<String>> getUrlsWork = new TransactionUtil.TransactionWork<List<String>>(){

            @Override
            public List<String> doWork() throws Exception {
                return ContentStoreCleaner.this.nodeDaoService.getContentDataStrings();
            }
        };
        List<String> contentDataStrings = TransactionUtil.executeInUserTransaction(this.transactionService, getUrlsWork, true);
        HashSet<String> validUrls = new HashSet<String>(contentDataStrings.size());
        for (String contentDataString : contentDataStrings) {
            ContentData contentData = ContentData.createContentProperty(contentDataString);
            if (contentData.getContentUrl() == null) continue;
            validUrls.add(contentData.getContentUrl());
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Found " + validUrls.size() + " valid URLs in metadata"));
        }
        return validUrls;
    }

    public void execute() {
        this.checkProperties();
        Set<String> validUrls = this.getValidUrls();
        for (ContentStore store : this.stores) {
            this.clean(validUrls, store);
        }
    }

    private void clean(Set<String> validUrls, ContentStore store) {
        Date checkAllBeforeDate = new Date(System.currentTimeMillis() - (long)this.protectDays * 3600L * 1000L * 24L);
        Set<String> storeUrls = store.getUrls(null, checkAllBeforeDate);
        storeUrls.removeAll(validUrls);
        for (String url : storeUrls) {
            ContentReader sourceReader = store.getReader(url);
            for (ContentStoreCleanerListener listener : this.listeners) {
                ContentReader listenerReader = sourceReader.getReader();
                listener.beforeDelete(listenerReader);
            }
            store.delete(url);
            if (!logger.isDebugEnabled()) continue;
            logger.debug((Object)("Removed URL from store: \n   Store: " + store + "\n" + "   URL: " + url));
        }
    }
}

