/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.cleanup;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import junit.framework.TestCase;
import org.alfresco.repo.content.ContentStore;
import org.alfresco.repo.content.cleanup.ContentStoreCleaner;
import org.alfresco.repo.content.cleanup.ContentStoreCleanerListener;
import org.alfresco.repo.content.filestore.FileContentStore;
import org.alfresco.repo.node.db.NodeDaoService;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.ContentIOException;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.TempFileProvider;
import org.springframework.context.ApplicationContext;

public class ContentStoreCleanerTest
extends TestCase {
    private static ApplicationContext ctx = ApplicationContextHelper.getApplicationContext();
    private ContentStoreCleaner cleaner;
    private ContentStore store;
    private ContentStoreCleanerListener listener;
    private List<String> deletedUrls;

    public void setUp() throws Exception {
        ServiceRegistry serviceRegistry = (ServiceRegistry)ctx.getBean("ServiceRegistry");
        TransactionService transactionService = serviceRegistry.getTransactionService();
        DictionaryService dictionaryService = serviceRegistry.getDictionaryService();
        NodeDaoService nodeDaoService = (NodeDaoService)ctx.getBean("nodeDaoService");
        this.store = new FileContentStore(TempFileProvider.getTempDir().getAbsolutePath());
        this.listener = new DummyCleanerListener();
        this.deletedUrls = new ArrayList<String>(5);
        this.cleaner = new ContentStoreCleaner();
        this.cleaner.setTransactionService(transactionService);
        this.cleaner.setDictionaryService(dictionaryService);
        this.cleaner.setNodeDaoService(nodeDaoService);
        this.cleaner.setStores(Collections.singletonList(this.store));
        this.cleaner.setListeners(Collections.singletonList(this.listener));
    }

    public void testImmediateRemoval() throws Exception {
        this.cleaner.setProtectDays(0);
        ContentWriter writer = this.store.getWriter(null, null);
        writer.putContent("ABC");
        String contentUrl = writer.getContentUrl();
        this.cleaner.execute();
        ContentStoreCleanerTest.assertFalse((String)"Unprotected content was not deleted", (boolean)this.store.exists(contentUrl));
        ContentStoreCleanerTest.assertTrue((String)"Content listener was not called with deletion", (boolean)this.deletedUrls.contains(contentUrl));
    }

    public void testProtectedRemoval() throws Exception {
        this.cleaner.setProtectDays(1);
        ContentWriter writer = this.store.getWriter(null, null);
        writer.putContent("ABC");
        String contentUrl = writer.getContentUrl();
        this.cleaner.execute();
        ContentStoreCleanerTest.assertTrue((String)"Protected content was deleted", (boolean)this.store.exists(contentUrl));
        ContentStoreCleanerTest.assertFalse((String)"Content listener was called with deletion of protected URL", (boolean)this.deletedUrls.contains(contentUrl));
    }

    private class DummyCleanerListener
    implements ContentStoreCleanerListener {
        private DummyCleanerListener() {
        }

        public void beforeDelete(ContentReader reader) throws ContentIOException {
            ContentStoreCleanerTest.this.deletedUrls.add(reader.getContentUrl());
        }
    }
}

