/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.cleanup;

import org.alfresco.repo.content.ContentStore;
import org.alfresco.repo.content.cleanup.ContentStoreCleanerListener;
import org.alfresco.service.cmr.repository.ContentIOException;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DeletedContentBackupCleanerListener
implements ContentStoreCleanerListener {
    private static Log logger = LogFactory.getLog(DeletedContentBackupCleanerListener.class);
    private ContentStore store;

    public void setStore(ContentStore store) {
        this.store = store;
    }

    public void beforeDelete(ContentReader reader) throws ContentIOException {
        ContentWriter writer = this.store.getWriter(null, reader.getContentUrl());
        writer.putContent(reader);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Moved content before deletion: \n   URL: " + reader.getContentUrl() + "\n" + "   Store: " + this.store));
        }
    }
}

