/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.filestore;

import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.content.AbstractContentStore;
import org.alfresco.repo.content.filestore.FileContentReader;
import org.alfresco.repo.content.filestore.FileContentWriter;
import org.alfresco.service.cmr.repository.ContentIOException;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileContentStore
extends AbstractContentStore {
    private static final Log logger = LogFactory.getLog(FileContentStore.class);
    private File rootDirectory;
    private String rootAbsolutePath;
    private boolean allowRandomAccess;

    public FileContentStore(String rootDirectoryStr) {
        this.rootDirectory = new File(rootDirectoryStr);
        if (!this.rootDirectory.exists() && !this.rootDirectory.mkdirs()) {
            throw new ContentIOException("Failed to create store root: " + this.rootDirectory, null);
        }
        this.rootDirectory = this.rootDirectory.getAbsoluteFile();
        this.rootAbsolutePath = this.rootDirectory.getAbsolutePath();
        this.allowRandomAccess = true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(36);
        sb.append("FileContentStore").append("[ root=").append(this.rootDirectory).append("]");
        return sb.toString();
    }

    public void setAllowRandomAccess(boolean allowRandomAccess) {
        this.allowRandomAccess = allowRandomAccess;
    }

    private File createNewFile() throws IOException {
        String contentUrl = FileContentStore.createNewUrl();
        return this.createNewFile(contentUrl);
    }

    public File createNewFile(String newContentUrl) throws IOException {
        boolean created;
        File file = this.makeFile(newContentUrl);
        File dir = file.getParentFile();
        if (!dir.exists()) {
            dir.mkdirs();
        }
        if (!(created = file.createNewFile())) {
            throw new ContentIOException("When specifying a URL for new content, the URL may not be in use already. \n   store: " + this + "\n" + "   new URL: " + newContentUrl);
        }
        return file;
    }

    private String makeContentUrl(File file) {
        String path = file.getAbsolutePath();
        if (!path.startsWith(this.rootAbsolutePath)) {
            throw new AlfrescoRuntimeException("File does not fall below the store's root: \n   file: " + file + "\n" + "   store: " + this);
        }
        int index = this.rootAbsolutePath.length();
        if (path.charAt(index) == File.separatorChar) {
            ++index;
        }
        String url = "store://" + path.substring(index);
        url = url.replace('\\', '/');
        return url;
    }

    private File makeFile(String contentUrl) {
        String relativeUrl = FileContentStore.getRelativePart(contentUrl);
        File file = new File(this.rootDirectory, relativeUrl);
        return file;
    }

    @Override
    public boolean exists(String contentUrl) throws ContentIOException {
        File file = this.makeFile(contentUrl);
        return file.exists();
    }

    @Override
    public ContentReader getReader(String contentUrl) {
        try {
            File file = this.makeFile(contentUrl);
            FileContentReader reader = new FileContentReader(file, contentUrl);
            reader.setAllowRandomAccess(this.allowRandomAccess);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Created content reader: \n   url: " + contentUrl + "\n" + "   file: " + file + "\n" + "   reader: " + reader));
            }
            return reader;
        }
        catch (Throwable e) {
            throw new ContentIOException("Failed to get reader for URL: " + contentUrl, e);
        }
    }

    @Override
    public ContentWriter getWriter(ContentReader existingContentReader, String newContentUrl) {
        try {
            File file = null;
            String contentUrl = null;
            if (newContentUrl == null) {
                file = this.createNewFile();
                contentUrl = this.makeContentUrl(file);
            } else {
                file = this.createNewFile(newContentUrl);
                contentUrl = newContentUrl;
            }
            FileContentWriter writer = new FileContentWriter(file, contentUrl, existingContentReader);
            writer.setAllowRandomAccess(this.allowRandomAccess);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Created content writer: \n   writer: " + writer));
            }
            return writer;
        }
        catch (IOException e) {
            throw new ContentIOException("Failed to get writer", e);
        }
    }

    @Override
    public Set<String> getUrls(Date createdAfter, Date createdBefore) {
        HashSet<String> contentUrls = new HashSet<String>(1000);
        this.getUrls(this.rootDirectory, contentUrls, createdAfter, createdBefore);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Listed all content URLS: \n   store: " + this + "\n" + "   count: " + contentUrls.size()));
        }
        return contentUrls;
    }

    private void getUrls(File directory, Set<String> contentUrls, Date createdAfter, Date createdBefore) {
        File[] files = directory.listFiles();
        if (files == null) {
            throw new ContentIOException("Failed list files in folder: " + directory);
        }
        for (File file : files) {
            if (file.isDirectory()) {
                this.getUrls(file, contentUrls, createdAfter, createdBefore);
                continue;
            }
            long lastModified = file.lastModified();
            if (createdAfter != null && lastModified < createdAfter.getTime() || createdBefore != null && lastModified > createdBefore.getTime()) continue;
            String contentUrl = this.makeContentUrl(file);
            contentUrls.add(contentUrl);
        }
    }

    @Override
    public boolean delete(String contentUrl) throws ContentIOException {
        File file = this.makeFile(contentUrl);
        boolean deleted = false;
        deleted = !file.exists() ? true : file.delete();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Delete content directly: \n   store: " + this + "\n" + "   url: " + contentUrl));
        }
        return deleted;
    }
}

