/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.filestore;

import java.io.File;
import org.alfresco.repo.content.AbstractContentReadWriteTest;
import org.alfresco.repo.content.ContentStore;
import org.alfresco.repo.content.filestore.FileContentReader;
import org.alfresco.repo.content.filestore.FileContentStore;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.util.TempFileProvider;

public class FileContentStoreTest
extends AbstractContentReadWriteTest {
    private FileContentStore store;

    public void setUp() throws Exception {
        super.setUp();
        File tempDir = TempFileProvider.getTempDir();
        this.store = new FileContentStore(tempDir.getAbsolutePath() + File.separatorChar + this.getName());
    }

    protected ContentStore getStore() {
        return this.store;
    }

    public void testGetSafeContentReader() throws Exception {
        String template = "ABC {0}{1}";
        String arg0 = "DEF";
        String arg1 = "123";
        String fakeContent = "ABC DEF123";
        ContentReader reader = this.getReader();
        FileContentStoreTest.assertFalse((String)"No content has been written to the URL yet", (boolean)reader.exists());
        File file = this.store.createNewFile(reader.getContentUrl());
        FileContentStoreTest.assertTrue((String)"File store did not connect new file", (boolean)file.exists());
        FileContentStoreTest.assertTrue((String)"Reader did not detect creation of the underlying file", (boolean)reader.exists());
        file.delete();
        FileContentStoreTest.assertFalse((String)"File not missing", (boolean)file.exists());
        FileContentStoreTest.assertFalse((String)"Reader doesn't show missing content", (boolean)reader.exists());
        ContentReader safeReader = FileContentReader.getSafeContentReader(reader, template, arg0, arg1);
        FileContentStoreTest.assertTrue((String)"Fake content doesn't exist", (boolean)safeReader.exists());
        FileContentStoreTest.assertEquals((String)"Fake content incorrect", (String)fakeContent, (String)safeReader.getContentString());
        FileContentStoreTest.assertEquals((String)"Fake mimetype incorrect", (String)"text/plain", (String)safeReader.getMimetype());
        FileContentStoreTest.assertEquals((String)"Fake encoding incorrect", (String)"UTF-8", (String)safeReader.getEncoding());
        reader = null;
        safeReader = FileContentReader.getSafeContentReader(reader, template, arg0, arg1);
        FileContentStoreTest.assertTrue((String)"Fake content doesn't exist", (boolean)safeReader.exists());
        FileContentStoreTest.assertEquals((String)"Fake content incorrect", (String)fakeContent, (String)safeReader.getContentString());
    }
}

