/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.filestore;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import junit.framework.TestCase;

public class FileIOTest
extends TestCase {
    private static final String TEST_CONTENT = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private File file;

    public FileIOTest(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        this.file = File.createTempFile(this.getName(), ".txt");
        FileOutputStream os = new FileOutputStream(this.file);
        ((OutputStream)os).write(TEST_CONTENT.getBytes());
        os.flush();
        ((OutputStream)os).close();
    }

    public void testConcurrentFileReads() throws Exception {
        FileInputStream isA = new FileInputStream(this.file);
        FileInputStream isB = new FileInputStream(this.file);
        FileChannel channelA = isA.getChannel();
        FileChannel channelB = isB.getChannel();
        ByteBuffer bufferA = ByteBuffer.allocate(10);
        ByteBuffer bufferB = ByteBuffer.allocate(10);
        int countA = 0;
        int countB = 0;
        do {
            countA = channelA.read((ByteBuffer)bufferA.clear());
            countB = channelB.read((ByteBuffer)bufferB.clear());
            FileIOTest.assertEquals((String)"Should read same number of bytes", (int)countA, (int)countB);
        } while (countA > 6);
        FileIOTest.assertEquals((String)"BufferA marker incorrect", (int)6, (int)bufferA.position());
        FileIOTest.assertEquals((String)"BufferB marker incorrect", (int)6, (int)bufferB.position());
    }

    public void testConcurrentReadWrite() throws Exception {
        FileInputStream isRead = new FileInputStream(this.file);
        FileOutputStream osWrite = new FileOutputStream(this.file);
        FileChannel channelRead = isRead.getChannel();
        FileChannel channelWrite = osWrite.getChannel();
        ByteBuffer bufferRead = ByteBuffer.allocate(26);
        ByteBuffer bufferWrite = ByteBuffer.wrap(TEST_CONTENT.getBytes());
        int countRead = channelRead.read(bufferRead);
        FileIOTest.assertEquals((String)"Expected nothing to be read", (int)-1, (int)countRead);
        int countWrite = channelWrite.write(bufferWrite);
        FileIOTest.assertEquals((String)"Not all characters written", (int)26, (int)countWrite);
        channelWrite.close();
        countRead = channelRead.read(bufferRead);
        FileIOTest.assertEquals((String)"Expected full read", (int)26, (int)countRead);
    }
}

