/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.metadata;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.content.MimetypeMap;
import org.alfresco.repo.content.filestore.FileContentReader;
import org.alfresco.repo.content.metadata.MetadataExtracter;
import org.alfresco.repo.content.transform.AbstractContentTransformerTest;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.TempFileProvider;
import org.springframework.context.ApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMetadataExtracterTest
extends TestCase {
    private static ApplicationContext ctx = ApplicationContextHelper.getApplicationContext();
    protected static final String QUICK_TITLE = "The quick brown fox jumps over the lazy dog";
    protected static final String QUICK_DESCRIPTION = "Gym class featuring a brown fox and lazy dog";
    protected static final String QUICK_CREATOR = "Nevin Nollop";
    protected MimetypeMap mimetypeMap;

    protected abstract MetadataExtracter getExtracter();

    public void setUp() throws Exception {
        this.mimetypeMap = (MimetypeMap)ctx.getBean("mimetypeService");
        long now = System.currentTimeMillis();
        TempFileProvider.TempFileCleanerJob.removeFiles((long)now);
    }

    public void testSetUp() throws Exception {
        AbstractMetadataExtracterTest.assertNotNull((String)"MimetypeMap not present", (Object)this.mimetypeMap);
        File sourceFile = AbstractContentTransformerTest.loadQuickTestFile("txt");
        AbstractMetadataExtracterTest.assertNotNull((String)"quick.* files should be available from Tests", (Object)sourceFile);
    }

    protected void testExtractFromMimetype(String mimetype) throws Exception {
        Map<QName, Serializable> properties = this.extractFromMimetype(mimetype);
        this.testCommonMetadata(mimetype, properties);
    }

    protected Map<QName, Serializable> extractFromMimetype(String mimetype) throws Exception {
        HashMap<QName, Serializable> properties = new HashMap<QName, Serializable>();
        String ext = this.mimetypeMap.getExtension(mimetype);
        File sourceFile = AbstractContentTransformerTest.loadQuickTestFile(ext);
        if (sourceFile == null) {
            throw new FileNotFoundException("No quick." + ext + " file found for test");
        }
        FileContentReader sourceReader = new FileContentReader(sourceFile);
        sourceReader.setMimetype(mimetype);
        this.getExtracter().extract(sourceReader, properties);
        return properties;
    }

    protected void testCommonMetadata(String mimetype, Map<QName, Serializable> properties) {
        AbstractMetadataExtracterTest.assertEquals((String)("Property " + ContentModel.PROP_TITLE + " not found for mimetype " + mimetype), (Object)QUICK_TITLE, (Object)properties.get(ContentModel.PROP_TITLE));
        AbstractMetadataExtracterTest.assertEquals((String)("Property " + ContentModel.PROP_DESCRIPTION + " not found for mimetype " + mimetype), (Object)QUICK_DESCRIPTION, (Object)properties.get(ContentModel.PROP_DESCRIPTION));
    }
}

