/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.metadata;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.text.ChangedCharSetException;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.parser.ParserDelegator;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.content.metadata.AbstractMetadataExtracter;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlMetadataExtracter
extends AbstractMetadataExtracter {
    private static final Set<String> MIMETYPES = new HashSet<String>(5);

    public HtmlMetadataExtracter() {
        super(MIMETYPES, 1.0, 1000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void extractInternal(ContentReader reader, Map<QName, Serializable> destination) throws Throwable {
        final HashMap tempDestination = new HashMap();
        HTMLEditorKit.ParserCallback callback = new HTMLEditorKit.ParserCallback(){
            StringBuffer title = null;
            boolean inHead = false;

            public void handleText(char[] data, int pos) {
                if (this.title != null) {
                    this.title.append(data);
                }
            }

            public void handleComment(char[] data, int pos) {
            }

            public void handleStartTag(HTML.Tag t, MutableAttributeSet a, int pos) {
                if (HTML.Tag.HEAD.equals(t)) {
                    this.inHead = true;
                } else if (HTML.Tag.TITLE.equals(t) && this.inHead) {
                    this.title = new StringBuffer();
                } else {
                    this.handleSimpleTag(t, a, pos);
                }
            }

            public void handleEndTag(HTML.Tag t, int pos) {
                if (HTML.Tag.HEAD.equals(t)) {
                    this.inHead = false;
                } else if (HTML.Tag.TITLE.equals(t) && this.title != null) {
                    HtmlMetadataExtracter.this.trimPut(ContentModel.PROP_TITLE, this.title.toString(), tempDestination);
                    this.title = null;
                }
            }

            public void handleSimpleTag(HTML.Tag t, MutableAttributeSet a, int pos) {
                if (HTML.Tag.META.equals(t)) {
                    Object nameO = a.getAttribute(HTML.Attribute.NAME);
                    Object valueO = a.getAttribute(HTML.Attribute.CONTENT);
                    if (nameO == null || valueO == null) {
                        return;
                    }
                    String name = nameO.toString();
                    if (name.equalsIgnoreCase("creator") || name.equalsIgnoreCase("author") || name.equalsIgnoreCase("dc.creator")) {
                        HtmlMetadataExtracter.this.trimPut(ContentModel.PROP_AUTHOR, valueO, tempDestination);
                    }
                    if (name.equalsIgnoreCase("description") || name.equalsIgnoreCase("dc.description")) {
                        HtmlMetadataExtracter.this.trimPut(ContentModel.PROP_DESCRIPTION, valueO, tempDestination);
                    }
                }
            }

            public void handleError(String errorMsg, int pos) {
            }
        };
        String charsetGuess = "UTF-8";
        int tries = 0;
        while (tries < 3) {
            tempDestination.clear();
            Reader r = null;
            InputStream cis = null;
            try {
                cis = reader.getContentInputStream();
                r = new InputStreamReader(cis);
                ParserDelegator parser = new ParserDelegator();
                ((HTMLEditorKit.Parser)parser).parse(r, callback, tries > 0);
                destination.putAll(tempDestination);
                break;
            }
            catch (ChangedCharSetException ccse) {
                ++tries;
                charsetGuess = ccse.getCharSetSpec();
                int begin = charsetGuess.indexOf("charset=");
                if (begin > 0) {
                    charsetGuess = charsetGuess.substring(begin + 8, charsetGuess.length());
                }
                reader = reader.getReader();
            }
            finally {
                if (r != null) {
                    r.close();
                }
                if (cis == null) continue;
                cis.close();
            }
        }
    }

    static {
        MIMETYPES.add("text/html");
        MIMETYPES.add("application/xhtml+xml");
    }
}

