/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.metadata;

import java.io.File;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.content.metadata.AbstractMetadataExtracter;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.TempFileProvider;
import org.farng.mp3.AbstractMP3FragmentBody;
import org.farng.mp3.MP3File;
import org.farng.mp3.id3.AbstractID3v2;
import org.farng.mp3.id3.AbstractID3v2Frame;
import org.farng.mp3.id3.ID3v1;
import org.farng.mp3.lyrics3.AbstractLyrics3;
import org.farng.mp3.lyrics3.Lyrics3v2;
import org.farng.mp3.lyrics3.Lyrics3v2Field;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MP3MetadataExtracter
extends AbstractMetadataExtracter {
    private static final QName PROP_ALBUM_TITLE = QName.createQName("{music}albumTitle");
    private static final QName PROP_SONG_TITLE = QName.createQName("{music}songTitle");
    private static final QName PROP_ARTIST = QName.createQName("{music}artist");
    private static final QName PROP_COMMENT = QName.createQName("{music}comment");
    private static final QName PROP_YEAR_RELEASED = QName.createQName("{music}yearReleased");
    private static final QName PROP_TRACK_NUMBER = QName.createQName("{music}trackNumber");
    private static final QName PROP_GENRE = QName.createQName("{music}genre");
    private static final QName PROP_COMPOSER = QName.createQName("{music}composer");
    private static final QName PROP_LYRICS = QName.createQName("{music}lyrics");

    public MP3MetadataExtracter() {
        super("audio/x-mpeg", 1.0, 1000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void extractInternal(ContentReader reader, Map<QName, Serializable> destination) throws Throwable {
        String description;
        HashMap<QName, Serializable> props = new HashMap<QName, Serializable>();
        File tempFile = TempFileProvider.createTempFile((String)"MP3MetadataExtracter_", (String)".tmp");
        try {
            AbstractLyrics3 lyrics3Tag;
            AbstractID3v2 id3v2;
            reader.getContent(tempFile);
            MP3File mp3File = new MP3File(tempFile);
            ID3v1 id3v1 = mp3File.getID3v1Tag();
            if (id3v1 != null) {
                this.setTagValue(props, PROP_ALBUM_TITLE, id3v1.getAlbum());
                this.setTagValue(props, PROP_SONG_TITLE, id3v1.getTitle());
                this.setTagValue(props, PROP_ARTIST, id3v1.getArtist());
                this.setTagValue(props, PROP_COMMENT, id3v1.getComment());
                this.setTagValue(props, PROP_YEAR_RELEASED, id3v1.getYear());
            }
            if ((id3v2 = mp3File.getID3v2Tag()) != null) {
                this.setTagValue(props, PROP_SONG_TITLE, this.getID3V2Value(id3v2, "TIT2"));
                this.setTagValue(props, PROP_ARTIST, this.getID3V2Value(id3v2, "TPE1"));
                this.setTagValue(props, PROP_ALBUM_TITLE, this.getID3V2Value(id3v2, "TALB"));
                this.setTagValue(props, PROP_YEAR_RELEASED, this.getID3V2Value(id3v2, "TDRC"));
                this.setTagValue(props, PROP_COMMENT, this.getID3V2Value(id3v2, "COMM"));
                this.setTagValue(props, PROP_TRACK_NUMBER, this.getID3V2Value(id3v2, "TRCK"));
                this.setTagValue(props, PROP_GENRE, this.getID3V2Value(id3v2, "TCON"));
                this.setTagValue(props, PROP_COMPOSER, this.getID3V2Value(id3v2, "TCOM"));
            }
            if ((lyrics3Tag = mp3File.getLyrics3Tag()) != null) {
                System.out.println("Lyrics3 tag found.");
                if (lyrics3Tag instanceof Lyrics3v2) {
                    this.setTagValue(props, PROP_SONG_TITLE, this.getLyrics3v2Value((Lyrics3v2)lyrics3Tag, "TIT2"));
                    this.setTagValue(props, PROP_ARTIST, this.getLyrics3v2Value((Lyrics3v2)lyrics3Tag, "TPE1"));
                    this.setTagValue(props, PROP_ALBUM_TITLE, this.getLyrics3v2Value((Lyrics3v2)lyrics3Tag, "TALB"));
                    this.setTagValue(props, PROP_COMMENT, this.getLyrics3v2Value((Lyrics3v2)lyrics3Tag, "COMM"));
                    this.setTagValue(props, PROP_LYRICS, this.getLyrics3v2Value((Lyrics3v2)lyrics3Tag, "SYLT"));
                    this.setTagValue(props, PROP_COMPOSER, this.getLyrics3v2Value((Lyrics3v2)lyrics3Tag, "TCOM"));
                }
            }
        }
        finally {
            tempFile.delete();
        }
        if (props.get(PROP_SONG_TITLE) != null) {
            destination.put(ContentModel.PROP_TITLE, (Serializable)props.get(PROP_SONG_TITLE));
        }
        if (props.get(PROP_ARTIST) != null) {
            destination.put(ContentModel.PROP_AUTHOR, (Serializable)props.get(PROP_ARTIST));
        }
        if ((description = this.getDescription(props)) != null) {
            destination.put(ContentModel.PROP_DESCRIPTION, (Serializable)((Object)description));
        }
    }

    private String getDescription(Map<QName, Serializable> props) {
        StringBuilder result = new StringBuilder();
        if (props.get(PROP_SONG_TITLE) != null && props.get(PROP_ARTIST) != null && props.get(PROP_ALBUM_TITLE) != null) {
            result.append(props.get(PROP_SONG_TITLE)).append(" - ").append(props.get(PROP_ALBUM_TITLE)).append(" (").append(props.get(PROP_ARTIST)).append(")");
        }
        return result.toString();
    }

    private void setTagValue(Map<QName, Serializable> props, QName propQName, String propvalue) {
        if (propvalue != null && propvalue.length() != 0) {
            this.trimPut(propQName, propvalue, props);
        }
    }

    private String getLyrics3v2Value(Lyrics3v2 lyrics3Tag, String name) {
        AbstractMP3FragmentBody body;
        String result = "";
        Lyrics3v2Field field = lyrics3Tag.getField(name);
        if (field != null && (body = field.getBody()) != null) {
            result = (String)body.getObject("Text");
        }
        return result;
    }

    private String getID3V2Value(AbstractID3v2 id3v2, String name) {
        AbstractMP3FragmentBody body;
        String result = "";
        AbstractID3v2Frame frame = id3v2.getFrame(name);
        if (frame != null && (body = frame.getBody()) != null) {
            result = (String)body.getObject("Text");
        }
        return result;
    }
}

