/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.metadata;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.content.MimetypeMap;
import org.alfresco.repo.content.metadata.MetadataExtracter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MetadataExtracterRegistry {
    private static final Log logger = LogFactory.getLog(MetadataExtracterRegistry.class);
    private List<MetadataExtracter> extracters = new ArrayList<MetadataExtracter>(10);
    private Map<String, MetadataExtracter> extracterCache = new HashMap<String, MetadataExtracter>(17);
    private MimetypeMap mimetypeMap;
    private Lock extracterCacheReadLock;
    private Lock extracterCacheWriteLock;

    public MetadataExtracterRegistry() {
        ReentrantReadWriteLock extractionCacheLock = new ReentrantReadWriteLock();
        this.extracterCacheReadLock = extractionCacheLock.readLock();
        this.extracterCacheWriteLock = extractionCacheLock.writeLock();
    }

    public void setMimetypeMap(MimetypeMap mimetypeMap) {
        this.mimetypeMap = mimetypeMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(MetadataExtracter extracter) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Registering metadata extracter: " + extracter));
        }
        this.extracterCacheWriteLock.lock();
        try {
            this.extracters.add(extracter);
            this.extracterCache.clear();
        }
        finally {
            this.extracterCacheWriteLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MetadataExtracter getExtracter(String sourceMimetype) {
        if (!this.mimetypeMap.getMimetypes().contains(sourceMimetype)) {
            throw new AlfrescoRuntimeException("Unknown extraction source mimetype: " + sourceMimetype);
        }
        MetadataExtracter extracter = null;
        this.extracterCacheReadLock.lock();
        try {
            if (this.extracterCache.containsKey(sourceMimetype)) {
                MetadataExtracter metadataExtracter = this.extracterCache.get(sourceMimetype);
                return metadataExtracter;
            }
        }
        finally {
            this.extracterCacheReadLock.unlock();
        }
        this.extracterCacheWriteLock.lock();
        try {
            extracter = this.findBestExtracter(sourceMimetype);
            this.extracterCache.put(sourceMimetype, extracter);
            MetadataExtracter metadataExtracter = extracter;
            return metadataExtracter;
        }
        finally {
            this.extracterCacheWriteLock.unlock();
        }
    }

    private MetadataExtracter findBestExtracter(String sourceMimetype) {
        double bestReliability = -1.0;
        long bestTime = Long.MAX_VALUE;
        logger.debug((Object)("Finding best extracter for " + sourceMimetype));
        MetadataExtracter bestExtracter = null;
        for (MetadataExtracter ext : this.extracters) {
            double r = ext.getReliability(sourceMimetype);
            if (r <= 0.0) continue;
            if (r == bestReliability) {
                long time = ext.getExtractionTime();
                if (time >= bestTime) continue;
                bestExtracter = ext;
                bestTime = time;
                continue;
            }
            if (!(r > bestReliability)) continue;
            bestExtracter = ext;
            bestReliability = r;
            bestTime = ext.getExtractionTime();
        }
        return bestExtracter;
    }
}

