/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.metadata;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.content.metadata.AbstractMetadataExtracter;
import org.alfresco.service.cmr.repository.ContentIOException;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.namespace.QName;
import org.apache.poi.hpsf.DocumentSummaryInformation;
import org.apache.poi.hpsf.PropertySet;
import org.apache.poi.hpsf.PropertySetFactory;
import org.apache.poi.hpsf.SummaryInformation;
import org.apache.poi.poifs.eventfilesystem.POIFSReader;
import org.apache.poi.poifs.eventfilesystem.POIFSReaderEvent;
import org.apache.poi.poifs.eventfilesystem.POIFSReaderListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OfficeMetadataExtracter
extends AbstractMetadataExtracter {
    public static String[] SUPPORTED_MIMETYPES = new String[]{"application/msword", "application/vnd.excel", "application/vnd.powerpoint"};

    public OfficeMetadataExtracter() {
        super(new HashSet<String>(Arrays.asList(SUPPORTED_MIMETYPES)), 1.0, 1000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void extractInternal(ContentReader reader, final Map<QName, Serializable> destination) throws Throwable {
        POIFSReaderListener readerListener = new POIFSReaderListener(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void processPOIFSReaderEvent(POIFSReaderEvent event) {
                try {
                    PropertySet ps = PropertySetFactory.create((InputStream)event.getStream());
                    if (ps instanceof SummaryInformation) {
                        SummaryInformation si = (SummaryInformation)ps;
                        OfficeMetadataExtracter.this.trimPut(ContentModel.PROP_TITLE, si.getTitle(), destination);
                        OfficeMetadataExtracter.this.trimPut(ContentModel.PROP_DESCRIPTION, si.getSubject(), destination);
                        OfficeMetadataExtracter.this.trimPut(ContentModel.PROP_CREATED, si.getCreateDateTime(), destination);
                        OfficeMetadataExtracter.this.trimPut(ContentModel.PROP_MODIFIED, si.getLastSaveDateTime(), destination);
                        OfficeMetadataExtracter.this.trimPut(ContentModel.PROP_AUTHOR, si.getAuthor(), destination);
                        return;
                    }
                    if (!(ps instanceof DocumentSummaryInformation)) return;
                }
                catch (Exception ex) {
                    throw new ContentIOException("Property set stream: " + event.getPath() + event.getName(), ex);
                }
            }
        };
        InputStream is = null;
        try {
            is = reader.getContentInputStream();
            POIFSReader poiFSReader = new POIFSReader();
            poiFSReader.registerListener(readerListener, "\u0005SummaryInformation");
            poiFSReader.read(is);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
    }
}

