/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.metadata;

import com.catcode.odf.ODFMetaFileAnalyzer;
import com.catcode.odf.OpenDocumentMetadata;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.content.metadata.AbstractMetadataExtracter;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenDocumentMetadataExtracter
extends AbstractMetadataExtracter {
    private static String[] mimeTypes = new String[]{"application/vnd.oasis.opendocument.text", "application/vnd.oasis.opendocument.text-template", "application/vnd.oasis.opendocument.graphics", "application/vnd.oasis.opendocument.graphics-template", "application/vnd.oasis.opendocument.presentation", "application/vnd.oasis.opendocument.presentation-template", "application/vnd.oasis.opendocument.spreadsheet", "application/vnd.oasis.opendocument.spreadsheet-template", "application/vnd.oasis.opendocument.chart", "applicationvnd.oasis.opendocument.chart-template", "application/vnd.oasis.opendocument.image", "applicationvnd.oasis.opendocument.image-template", "application/vnd.oasis.opendocument.formula", "applicationvnd.oasis.opendocument.formula-template", "application/vnd.oasis.opendocument.text-master", "application/vnd.oasis.opendocument.text-web", "application/vnd.oasis.opendocument.database"};

    public OpenDocumentMetadataExtracter() {
        super(new HashSet<String>(Arrays.asList(mimeTypes)), 1.0, 1000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void extractInternal(ContentReader reader, Map<QName, Serializable> destination) throws Throwable {
        ODFMetaFileAnalyzer analyzer = new ODFMetaFileAnalyzer();
        InputStream is = null;
        try {
            is = reader.getContentInputStream();
            OpenDocumentMetadata docInfo = analyzer.analyzeZip(is);
            if (docInfo != null) {
                destination.put(ContentModel.PROP_AUTHOR, (Serializable)((Object)docInfo.getCreator()));
                destination.put(ContentModel.PROP_TITLE, (Serializable)((Object)docInfo.getTitle()));
                destination.put(ContentModel.PROP_DESCRIPTION, (Serializable)((Object)docInfo.getDescription()));
                destination.put(ContentModel.PROP_CREATED, docInfo.getCreationDate());
            }
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
    }
}

