/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.metadata;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.content.metadata.AbstractMetadataExtracter;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.namespace.QName;
import org.pdfbox.pdmodel.PDDocument;
import org.pdfbox.pdmodel.PDDocumentInformation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PdfBoxMetadataExtracter
extends AbstractMetadataExtracter {
    public PdfBoxMetadataExtracter() {
        super("application/pdf", 1.0, 1000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void extractInternal(ContentReader reader, Map<QName, Serializable> destination) throws Throwable {
        PDDocument pdf = null;
        InputStream is = null;
        try {
            is = reader.getContentInputStream();
            pdf = PDDocument.load((InputStream)is);
            PDDocumentInformation docInfo = pdf.getDocumentInformation();
            this.trimPut(ContentModel.PROP_AUTHOR, docInfo.getAuthor(), destination);
            this.trimPut(ContentModel.PROP_TITLE, docInfo.getTitle(), destination);
            this.trimPut(ContentModel.PROP_DESCRIPTION, docInfo.getSubject(), destination);
            Calendar created = docInfo.getCreationDate();
            if (created != null) {
                destination.put(ContentModel.PROP_CREATED, created.getTime());
            }
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
            if (pdf != null) {
                try {
                    pdf.close();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

