/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.metadata;

import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.XPropertySet;
import com.sun.star.document.XDocumentInfoSupplier;
import com.sun.star.frame.XComponentLoader;
import com.sun.star.lang.XComponent;
import com.sun.star.ucb.XFileIdentifierConverter;
import com.sun.star.uno.UnoRuntime;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.Serializable;
import java.net.ConnectException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import net.sf.joott.uno.UnoConnection;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.content.metadata.AbstractMetadataExtracter;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.TempFileProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnoMetadataExtracter
extends AbstractMetadataExtracter {
    public static String[] SUPPORTED_MIMETYPES = new String[]{"application/vnd.stardivision.writer", "application/vnd.stardivision.impress", "application/vnd.sun.xml.writer", "application/vnd.sun.xml.impress"};
    private String contentUrl = "socket,host=localhost,port=8100,tcpNoDelay=1";
    private MyUnoConnection connection;
    private boolean isConnected;

    public UnoMetadataExtracter() {
        super(new HashSet<String>(Arrays.asList(SUPPORTED_MIMETYPES)), 1.0, 10000L);
    }

    public void setContentUrl(String contentUrl) {
        this.contentUrl = contentUrl;
    }

    public synchronized void init() {
        this.connection = new MyUnoConnection(this.contentUrl);
        try {
            this.connection.connect();
            this.isConnected = true;
            super.register();
        }
        catch (ConnectException e) {
            this.isConnected = false;
        }
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void extractInternal(ContentReader reader, Map<QName, Serializable> destination) throws Throwable {
        String sourceMimetype = reader.getMimetype();
        File tempFromFile = TempFileProvider.createTempFile((String)"UnoContentTransformer_", (String)("." + this.getMimetypeService().getExtension(sourceMimetype)));
        reader.getContent(tempFromFile);
        String sourceUrl = this.toUrl(tempFromFile, this.connection);
        MyUnoConnection myUnoConnection = this.connection;
        synchronized (myUnoConnection) {
            XComponentLoader desktop = this.connection.getDesktop();
            XComponent document = desktop.loadComponentFromURL(sourceUrl, "_blank", 0, new PropertyValue[]{UnoMetadataExtracter.property("Hidden", Boolean.TRUE)});
            if (document == null) {
                throw new FileNotFoundException("could not open source document: " + sourceUrl);
            }
            try {
                XDocumentInfoSupplier infoSupplier = (XDocumentInfoSupplier)UnoRuntime.queryInterface(XDocumentInfoSupplier.class, (Object)document);
                XPropertySet propSet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)infoSupplier.getDocumentInfo());
                this.trimPut(ContentModel.PROP_TITLE, propSet.getPropertyValue("Title"), destination);
                this.trimPut(ContentModel.PROP_DESCRIPTION, propSet.getPropertyValue("Subject"), destination);
                this.trimPut(ContentModel.PROP_AUTHOR, propSet.getPropertyValue("Author"), destination);
            }
            finally {
                document.dispose();
            }
        }
    }

    public String toUrl(File file, MyUnoConnection connection) throws ConnectException {
        Object fcp = connection.getFileContentService();
        XFileIdentifierConverter fic = (XFileIdentifierConverter)UnoRuntime.queryInterface(XFileIdentifierConverter.class, (Object)fcp);
        return fic.getFileURLFromSystemPath("", file.getAbsolutePath());
    }

    @Override
    public double getReliability(String sourceMimetype) {
        if (this.isConnected()) {
            return super.getReliability(sourceMimetype);
        }
        return 0.0;
    }

    private static PropertyValue property(String name, Object value) {
        PropertyValue property = new PropertyValue();
        property.Name = name;
        property.Value = value;
        return property;
    }

    static class MyUnoConnection
    extends UnoConnection {
        public MyUnoConnection(String url) {
            super(url);
        }

        public Object getFileContentService() throws ConnectException {
            return this.getService("com.sun.star.ucb.FileContentProvider");
        }
    }
}

