/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.metadata;

import org.alfresco.repo.content.metadata.AbstractMetadataExtracterTest;
import org.alfresco.repo.content.metadata.MetadataExtracter;
import org.alfresco.repo.content.metadata.UnoMetadataExtracter;

public class UnoMetadataExtracterTest
extends AbstractMetadataExtracterTest {
    private UnoMetadataExtracter extracter;

    public void setUp() throws Exception {
        super.setUp();
        this.extracter = new UnoMetadataExtracter();
        this.extracter.setMimetypeService(this.mimetypeMap);
        this.extracter.init();
    }

    protected MetadataExtracter getExtracter() {
        return this.extracter;
    }

    public void testReliability() throws Exception {
        if (!this.extracter.isConnected()) {
            return;
        }
        for (String mimetype : UnoMetadataExtracter.SUPPORTED_MIMETYPES) {
            double reliability = this.extracter.getReliability(mimetype);
            UnoMetadataExtracterTest.assertTrue((String)"Expected above zero reliability", (reliability > 0.0 ? 1 : 0) != 0);
        }
    }

    public void testSupportedMimetypes() throws Exception {
        if (!this.extracter.isConnected()) {
            return;
        }
        for (String mimetype : UnoMetadataExtracter.SUPPORTED_MIMETYPES) {
            this.testExtractFromMimetype(mimetype);
        }
    }
}

