/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.replication;

import java.io.File;
import java.util.Set;
import junit.framework.TestCase;
import org.alfresco.repo.content.AbstractContentStore;
import org.alfresco.repo.content.ContentStore;
import org.alfresco.repo.content.filestore.FileContentStore;
import org.alfresco.repo.content.replication.ContentStoreReplicator;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.util.GUID;
import org.alfresco.util.TempFileProvider;

public class ContentStoreReplicatorTest
extends TestCase {
    private static final String SOME_CONTENT = "The No. 1 Ladies' Detective Agency";
    private ContentStoreReplicator replicator;
    private ContentStore sourceStore;
    private ContentStore targetStore;

    public void setUp() throws Exception {
        super.setUp();
        File tempDir = TempFileProvider.getTempDir();
        String storeDir = tempDir.getAbsolutePath() + File.separatorChar + this.getName() + File.separatorChar + GUID.generate();
        this.sourceStore = new FileContentStore(storeDir);
        storeDir = tempDir.getAbsolutePath() + File.separatorChar + this.getName() + File.separatorChar + GUID.generate();
        this.targetStore = new FileContentStore(storeDir);
        this.replicator = new ContentStoreReplicator();
        this.replicator.setSourceStore(this.sourceStore);
        this.replicator.setTargetStore(this.targetStore);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSinglePassReplication() throws Exception {
        ContentWriter writer = this.sourceStore.getWriter(null, null);
        writer.putContent("123");
        this.replicator.start();
        ContentStoreReplicatorTest contentStoreReplicatorTest = this;
        synchronized (contentStoreReplicatorTest) {
            ((Object)((Object)this)).wait(1000L);
        }
        ContentStoreReplicatorTest.assertTrue((String)"Target store doesn't have content added to source", (boolean)this.targetStore.exists(writer.getContentUrl()));
        writer = this.sourceStore.getWriter(null, null);
        writer.putContent("456");
        contentStoreReplicatorTest = this;
        synchronized (contentStoreReplicatorTest) {
            ((Object)((Object)this)).wait(1000L);
        }
        ContentStoreReplicatorTest.assertFalse((String)"Replication should have been single-pass", (boolean)this.targetStore.exists(writer.getContentUrl()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testContinuousReplication() throws Exception {
        this.replicator.start();
        String duplicateUrl = AbstractContentStore.createNewUrl();
        for (int i = 0; i < 10; ++i) {
            duplicateUrl = AbstractContentStore.createNewUrl();
            ContentWriter duplicateTargetWriter = this.targetStore.getWriter(null, duplicateUrl);
            ContentWriter duplicateSourceWriter = this.sourceStore.getWriter(null, duplicateUrl);
            duplicateTargetWriter.putContent("Duplicate Target Content: " + i);
            duplicateSourceWriter.putContent(duplicateTargetWriter.getReader());
            for (int j = 0; j < 100; ++j) {
                ContentWriter writer = this.sourceStore.getWriter(null, null);
                writer.putContent("Repeated put: " + j);
            }
        }
        this.targetStore.delete(duplicateUrl);
        ContentStoreReplicatorTest i = this;
        synchronized (i) {
            ((Object)((Object)this)).wait(1000L);
        }
        Set<String> sourceUrls = this.sourceStore.getUrls();
        Set<String> targetUrls = this.targetStore.getUrls();
        sourceUrls.containsAll(targetUrls);
        targetUrls.contains(sourceUrls);
    }

    public void testRepeatedReplication() throws Exception {
        for (int i = 0; i < 10; ++i) {
            this.replicator.start();
        }
    }
}

