/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.replication;

import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.content.AbstractContentStore;
import org.alfresco.repo.content.ContentStore;
import org.alfresco.service.cmr.repository.ContentIOException;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentStreamListener;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.transaction.TransactionService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplicatingContentStore
extends AbstractContentStore {
    private static Log logger = LogFactory.getLog(ReplicatingContentStore.class);
    private TransactionService transactionService;
    private ContentStore primaryStore;
    private List<ContentStore> secondaryStores;
    private boolean inbound = false;
    private boolean outbound = true;
    private ThreadPoolExecutor outboundThreadPoolExecutor;
    private Lock readLock;
    private Lock writeLock;

    public ReplicatingContentStore() {
        ReentrantReadWriteLock storeLock = new ReentrantReadWriteLock();
        this.readLock = storeLock.readLock();
        this.writeLock = storeLock.writeLock();
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void setPrimaryStore(ContentStore primaryStore) {
        this.primaryStore = primaryStore;
    }

    public void setSecondaryStores(List<ContentStore> secondaryStores) {
        this.secondaryStores = secondaryStores;
    }

    public void setInbound(boolean inbound) {
        this.inbound = inbound;
    }

    public void setOutbound(boolean outbound) {
        this.outbound = outbound;
    }

    public void setOutboundThreadPoolExecutor(ThreadPoolExecutor outboundThreadPoolExecutor) {
        this.outboundThreadPoolExecutor = outboundThreadPoolExecutor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ContentReader getReader(String contentUrl) throws ContentIOException {
        ContentReader contentReader;
        ContentReader secondaryContentReader;
        if (this.primaryStore == null) {
            throw new AlfrescoRuntimeException("ReplicatingContentStore not initialised");
        }
        ContentReader existingContentReader = null;
        this.readLock.lock();
        try {
            ContentReader primaryReader = this.primaryStore.getReader(contentUrl);
            if (primaryReader.exists()) {
                ContentReader contentReader2 = primaryReader;
                return contentReader2;
            }
            secondaryContentReader = null;
            for (ContentStore store : this.secondaryStores) {
                ContentReader reader = store.getReader(contentUrl);
                if (!reader.exists()) continue;
                secondaryContentReader = reader;
                break;
            }
            if (secondaryContentReader == null) {
                contentReader = primaryReader;
                return contentReader;
            }
            if (!this.inbound) {
                contentReader = secondaryContentReader;
                return contentReader;
            }
            existingContentReader = secondaryContentReader;
        }
        finally {
            this.readLock.unlock();
        }
        this.writeLock.lock();
        try {
            ContentReader primaryContentReader = this.primaryStore.getReader(contentUrl);
            if (primaryContentReader.exists()) {
                secondaryContentReader = primaryContentReader;
                return secondaryContentReader;
            }
            ContentWriter primaryContentWriter = this.primaryStore.getWriter(existingContentReader, contentUrl);
            primaryContentWriter.putContent(existingContentReader);
            contentReader = primaryContentReader = primaryContentWriter.getReader();
            return contentReader;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public ContentWriter getWriter(ContentReader existingContentReader, String newContentUrl) throws ContentIOException {
        ContentWriter writer = this.primaryStore.getWriter(existingContentReader, newContentUrl);
        if (this.outbound) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Attaching " + (this.outboundThreadPoolExecutor == null ? "" : "a") + "synchronous " + "replicating listener to local writer: \n" + "   primary store: " + this.primaryStore + "\n" + "   writer: " + writer));
            }
            ReplicatingWriteListener listener = new ReplicatingWriteListener(this.secondaryStores, writer, this.outboundThreadPoolExecutor);
            writer.addListener(listener);
            writer.setTransactionService(this.transactionService);
        }
        return writer;
    }

    @Override
    public boolean delete(String contentUrl) throws ContentIOException {
        boolean deleted = this.primaryStore.delete(contentUrl);
        if (this.outbound) {
            for (ContentStore store : this.secondaryStores) {
                store.delete(contentUrl);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Propagated content delete to " + this.secondaryStores.size() + " stores:" + contentUrl));
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Deleted content for URL: " + contentUrl));
        }
        return deleted;
    }

    @Override
    public Set<String> getUrls(Date createdAfter, Date createdBefore) throws ContentIOException {
        HashSet<String> urls = new HashSet<String>(1024);
        Set<String> primaryUrls = this.primaryStore.getUrls(createdAfter, createdBefore);
        urls.addAll(primaryUrls);
        for (ContentStore secondaryStore : this.secondaryStores) {
            Set<String> secondaryUrls = secondaryStore.getUrls(createdAfter, createdBefore);
            urls.addAll(secondaryUrls);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Found " + urls.size() + " URLs, of which " + primaryUrls.size() + " are primary: \n" + "   created after: " + createdAfter + "\n" + "   created before: " + createdBefore));
        }
        return urls;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ReplicatingWriteListener
    implements ContentStreamListener {
        private List<ContentStore> stores;
        private ContentWriter writer;
        private ThreadPoolExecutor threadPoolExecutor;

        public ReplicatingWriteListener(List<ContentStore> stores, ContentWriter writer, ThreadPoolExecutor threadPoolExecutor) {
            this.stores = stores;
            this.writer = writer;
            this.threadPoolExecutor = threadPoolExecutor;
        }

        @Override
        public void contentStreamClosed() throws ContentIOException {
            ReplicateOnCloseRunnable runnable = new ReplicateOnCloseRunnable();
            if (this.threadPoolExecutor == null) {
                runnable.run();
            } else {
                this.threadPoolExecutor.execute(runnable);
            }
        }

        private class ReplicateOnCloseRunnable
        implements Runnable {
            private ReplicateOnCloseRunnable() {
            }

            public void run() {
                for (ContentStore store : ReplicatingWriteListener.this.stores) {
                    try {
                        ContentReader reader = ReplicatingWriteListener.this.writer.getReader();
                        String contentUrl = reader.getContentUrl();
                        ContentWriter replicatedWriter = store.getWriter(null, contentUrl);
                        replicatedWriter.putContent(reader);
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug((Object)("Replicated content to store: \n   url: " + contentUrl + "\n" + "   to store: " + store));
                    }
                    catch (Throwable e) {
                        throw new ContentIOException("Content replication failed: \n   url: " + ReplicatingWriteListener.this.writer.getContentUrl() + "\n" + "   to store: " + store);
                    }
                }
            }
        }
    }
}

