/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.replication;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.alfresco.repo.content.AbstractContentReadWriteTest;
import org.alfresco.repo.content.ContentStore;
import org.alfresco.repo.content.filestore.FileContentStore;
import org.alfresco.repo.content.replication.ReplicatingContentStore;
import org.alfresco.repo.transaction.DummyTransactionService;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.util.GUID;
import org.alfresco.util.TempFileProvider;

public class ReplicatingContentStoreTest
extends AbstractContentReadWriteTest {
    private static final String SOME_CONTENT = "The No. 1 Ladies' Detective Agency";
    private ReplicatingContentStore replicatingStore;
    private ContentStore primaryStore;
    private List<ContentStore> secondaryStores;

    public void setUp() throws Exception {
        super.setUp();
        File tempDir = TempFileProvider.getTempDir();
        String storeDir = tempDir.getAbsolutePath() + File.separatorChar + GUID.generate();
        this.primaryStore = new FileContentStore(storeDir);
        this.secondaryStores = new ArrayList<ContentStore>(3);
        for (int i = 0; i < 3; ++i) {
            storeDir = tempDir.getAbsolutePath() + File.separatorChar + GUID.generate();
            FileContentStore store = new FileContentStore(storeDir);
            this.secondaryStores.add(store);
        }
        this.replicatingStore = new ReplicatingContentStore();
        this.replicatingStore.setTransactionService(new DummyTransactionService());
        this.replicatingStore.setPrimaryStore(this.primaryStore);
        this.replicatingStore.setSecondaryStores(this.secondaryStores);
        this.replicatingStore.setOutbound(false);
        this.replicatingStore.setInbound(false);
    }

    public ContentStore getStore() {
        return this.replicatingStore;
    }

    private void checkForReplication(boolean inbound, boolean outbound, String contentUrl, String content) {
        if (inbound) {
            ContentReader reader = this.primaryStore.getReader(contentUrl);
            ReplicatingContentStoreTest.assertTrue((String)"Content was not replicated into the primary store", (boolean)reader.exists());
            ReplicatingContentStoreTest.assertEquals((String)"The replicated content was incorrect", (String)content, (String)reader.getContentString());
        }
        if (outbound) {
            for (ContentStore store : this.secondaryStores) {
                ContentReader reader = store.getReader(contentUrl);
                ReplicatingContentStoreTest.assertTrue((String)"Content was not replicated out to the secondary stores within a second", (boolean)reader.exists());
                ReplicatingContentStoreTest.assertEquals((String)"The replicated content was incorrect", (String)content, (String)reader.getContentString());
            }
        }
    }

    private void checkForUrl(String contentUrl, boolean mustExist) {
        for (ContentStore store : this.secondaryStores) {
            Set<String> urls = store.getUrls();
            ReplicatingContentStoreTest.assertTrue((String)"URL of new content not present in store", (urls.contains(contentUrl) == mustExist ? 1 : 0) != 0);
        }
    }

    public void testNoReplication() throws Exception {
        ContentWriter writer = this.getWriter();
        writer.putContent(SOME_CONTENT);
        this.checkForReplication(false, false, writer.getContentUrl(), SOME_CONTENT);
    }

    public void testOutboundReplication() throws Exception {
        this.replicatingStore.setOutbound(true);
        ContentWriter writer = this.getWriter();
        writer.putContent(SOME_CONTENT);
        String contentUrl = writer.getContentUrl();
        this.checkForReplication(false, true, contentUrl, SOME_CONTENT);
        this.replicatingStore.delete(contentUrl);
        this.checkForUrl(contentUrl, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAsyncOutboundReplication() throws Exception {
        ThreadPoolExecutor tpe = new ThreadPoolExecutor(1, 1, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
        this.replicatingStore.setOutbound(true);
        this.replicatingStore.setOutboundThreadPoolExecutor(tpe);
        ContentWriter writer = this.getWriter();
        writer.putContent(SOME_CONTENT);
        String contentUrl = writer.getContentUrl();
        ReplicatingContentStoreTest replicatingContentStoreTest = this;
        synchronized (replicatingContentStoreTest) {
            ((Object)((Object)this)).wait(1000L);
        }
        this.checkForReplication(false, true, contentUrl, SOME_CONTENT);
        this.replicatingStore.delete(contentUrl);
        this.checkForUrl(contentUrl, false);
    }

    public void testInboundReplication() throws Exception {
        this.replicatingStore.setInbound(false);
        ContentStore secondaryStore = this.secondaryStores.get(2);
        ContentWriter writer = secondaryStore.getWriter(null, null);
        writer.putContent(SOME_CONTENT);
        String contentUrl = writer.getContentUrl();
        ContentReader reader = this.replicatingStore.getReader(contentUrl);
        ReplicatingContentStoreTest.assertTrue((String)"Reader must have been found in secondary store", (boolean)reader.exists());
        this.replicatingStore.setInbound(true);
        reader = this.replicatingStore.getReader(contentUrl);
        this.checkForReplication(true, false, contentUrl, SOME_CONTENT);
    }
}

