/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.transform;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.content.transform.ContentTransformer;
import org.alfresco.repo.content.transform.ContentTransformerRegistry;
import org.alfresco.service.cmr.repository.ContentAccessor;
import org.alfresco.service.cmr.repository.ContentIOException;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.MimetypeService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractContentTransformer
implements ContentTransformer {
    private static final Log logger = LogFactory.getLog(AbstractContentTransformer.class);
    private MimetypeService mimetypeService;
    private ContentTransformerRegistry registry;
    private List<ContentTransformerRegistry.TransformationKey> explicitTransformations = new ArrayList<ContentTransformerRegistry.TransformationKey>(0);
    private double averageTime = 0.0;
    private long count = 0L;

    protected AbstractContentTransformer() {
    }

    public void setRegistry(ContentTransformerRegistry registry) {
        this.registry = registry;
    }

    public void setMimetypeService(MimetypeService mimetypeService) {
        this.mimetypeService = mimetypeService;
    }

    protected MimetypeService getMimetypeService() {
        return this.mimetypeService;
    }

    protected List<ContentTransformerRegistry.TransformationKey> getExplicitTransformations() {
        return this.explicitTransformations;
    }

    public void setExplicitTransformations(List<ContentTransformerRegistry.TransformationKey> explicitTransformations) {
        this.explicitTransformations = explicitTransformations;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("[ average=").append((long)this.averageTime).append("ms").append("]");
        return sb.toString();
    }

    public void register() {
        if (this.registry == null) {
            if (this.registry == null) {
                logger.warn((Object)("Property 'registry' has not been set.  Ignoring auto-registration: \n   transformer: " + this));
                return;
            }
            return;
        }
        if (this.explicitTransformations != null) {
            for (ContentTransformerRegistry.TransformationKey key : this.explicitTransformations) {
                this.registry.addExplicitTransformer(key, this);
            }
        }
        this.registry.addTransformer(this);
    }

    protected String getMimetype(ContentAccessor content) {
        String mimetype = content.getMimetype();
        if (mimetype == null) {
            throw new AlfrescoRuntimeException("Mimetype is mandatory for transformation: " + content);
        }
        return mimetype;
    }

    protected void checkReliability(ContentReader reader, ContentWriter writer) {
        String targetMimetype;
        String sourceMimetype = this.getMimetype(reader);
        double reliability = this.getReliability(sourceMimetype, targetMimetype = this.getMimetype(writer));
        if (reliability <= 0.0) {
            throw new AlfrescoRuntimeException("Zero scoring transformation attempted: \n   reader: " + reader + "\n" + "   writer: " + writer);
        }
    }

    protected abstract void transformInternal(ContentReader var1, ContentWriter var2, Map<String, Object> var3) throws Exception;

    @Override
    public final void transform(ContentReader reader, ContentWriter writer) throws ContentIOException {
        this.transform(reader, writer, null);
    }

    @Override
    public final void transform(ContentReader reader, ContentWriter writer, Map<String, Object> options) throws ContentIOException {
        long before = System.currentTimeMillis();
        this.checkReliability(reader, writer);
        if (options == null) {
            options = Collections.emptyMap();
        }
        try {
            this.transformInternal(reader, writer, options);
        }
        catch (Throwable e) {
            this.recordTime(10000L);
            throw new ContentIOException("Content conversion failed: \n   reader: " + reader + "\n" + "   writer: " + writer + "\n" + "   options: " + options, e);
        }
        finally {
            if (!reader.isClosed()) {
                logger.error((Object)("Content reader not closed by transformer: \n   reader: " + reader + "\n" + "   transformer: " + this));
            }
            if (!writer.isClosed()) {
                logger.error((Object)("Content writer not closed by transformer: \n   writer: " + writer + "\n" + "   transformer: " + this));
            }
        }
        long after = System.currentTimeMillis();
        this.recordTime(after - before);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Completed transformation: \n   reader: " + reader + "\n" + "   writer: " + writer + "\n" + "   options: " + options + "\n" + "   transformer: " + this));
        }
    }

    @Override
    public synchronized long getTransformationTime() {
        return (long)this.averageTime;
    }

    protected final synchronized void recordTime(long transformationTime) {
        if (this.count == Long.MAX_VALUE) {
            this.count /= 2L;
        }
        ++this.count;
        double diffTime = (double)transformationTime - this.averageTime;
        this.averageTime += diffTime / (double)this.count;
    }
}

