/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.transform;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import org.alfresco.repo.content.MimetypeMap;
import org.alfresco.repo.content.filestore.FileContentReader;
import org.alfresco.repo.content.filestore.FileContentWriter;
import org.alfresco.repo.content.transform.ContentTransformer;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.util.BaseSpringTest;
import org.alfresco.util.TempFileProvider;

public abstract class AbstractContentTransformerTest
extends BaseSpringTest {
    private static String QUICK_CONTENT = "The quick brown fox jumps over the lazy dog";
    private static String[] QUICK_WORDS = new String[]{"quick", "brown", "fox", "jumps", "lazy", "dog"};
    protected MimetypeMap mimetypeMap;

    public final void setMimetypeMap(MimetypeMap mimetypeMap) {
        this.mimetypeMap = mimetypeMap;
    }

    protected abstract ContentTransformer getTransformer(String var1, String var2);

    protected void onSetUpInTransaction() throws Exception {
        long now = System.currentTimeMillis();
        TempFileProvider.TempFileCleanerJob.removeFiles((long)now);
    }

    public void testSetUp() throws Exception {
        AbstractContentTransformerTest.assertNotNull((String)"MimetypeMap not present", (Object)this.mimetypeMap);
        File sourceFile = AbstractContentTransformerTest.loadQuickTestFile("txt");
        AbstractContentTransformerTest.assertNotNull((Object)sourceFile);
    }

    public static File loadQuickTestFile(String extension) throws IOException {
        URL url = AbstractContentTransformerTest.class.getClassLoader().getResource("quick/quick." + extension);
        if (url == null) {
            return null;
        }
        File file = new File(url.getFile());
        if (!file.exists()) {
            return null;
        }
        return file;
    }

    public void testAllConversions() throws Exception {
        List<String> mimetypes = this.mimetypeMap.getMimetypes();
        for (String sourceMimetype : mimetypes) {
            String sourceExtension = this.mimetypeMap.getExtension(sourceMimetype);
            File sourceFile = AbstractContentTransformerTest.loadQuickTestFile(sourceExtension);
            if (sourceFile == null) continue;
            for (String targetMimetype : mimetypes) {
                ContentTransformer transformer;
                FileContentWriter targetWriter = null;
                FileContentReader sourceReader = new FileContentReader(sourceFile);
                int count = 0;
                for (int i = 0; i < 5 && (transformer = this.getTransformer(sourceMimetype, targetMimetype)) != null && !(transformer.getReliability(sourceMimetype, targetMimetype) <= 0.0); ++i) {
                    String checkContent;
                    ContentReader targetReader;
                    String targetExtension = this.mimetypeMap.getExtension(targetMimetype);
                    File targetFile = TempFileProvider.createTempFile((String)(((Object)((Object)this)).getClass().getSimpleName() + "_" + this.getName() + "_" + sourceExtension + "_"), (String)("." + targetExtension));
                    targetWriter = new FileContentWriter(targetFile);
                    sourceReader.setMimetype(sourceMimetype);
                    targetWriter.setMimetype(targetMimetype);
                    transformer.transform(sourceReader.getReader(), targetWriter);
                    if (targetMimetype.equals("text/plain")) {
                        targetReader = targetWriter.getReader();
                        checkContent = targetReader.getContentString();
                        AbstractContentTransformerTest.assertTrue((String)("Quick phrase not present in document converted to text: \n   transformer: " + transformer + "\n" + "   source: " + sourceReader + "\n" + "   target: " + targetWriter), (boolean)checkContent.contains(QUICK_CONTENT));
                    } else if (targetMimetype.startsWith("text/")) {
                        targetReader = targetWriter.getReader();
                        checkContent = targetReader.getContentString();
                        for (int word = 0; word < QUICK_WORDS.length; ++word) {
                            AbstractContentTransformerTest.assertTrue((String)("Quick phrase word not present in document converted to text: \n   transformer: " + transformer + "\n" + "   source: " + sourceReader + "\n" + "   target: " + targetWriter + "\n" + "   word: " + word), (boolean)checkContent.contains(QUICK_WORDS[word]));
                        }
                    }
                    ++count;
                }
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug((Object)("Transformation performed " + count + " time: " + sourceMimetype + " --> " + targetMimetype + "\n" + "   source: " + sourceReader + "\n" + "   target: " + targetWriter + "\n" + "   transformer: " + this.getTransformer(sourceMimetype, targetMimetype)));
            }
        }
    }
}

