/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.transform;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.alfresco.repo.content.transform.AbstractContentTransformerTest;
import org.alfresco.repo.content.transform.ComplexContentTransformer;
import org.alfresco.repo.content.transform.ContentTransformer;

public class ComplexContentTransformerTest
extends AbstractContentTransformerTest {
    private ComplexContentTransformer transformer;
    private boolean isAvailable;

    public void onSetUpInTransaction() throws Exception {
        ContentTransformer unoTransformer = (ContentTransformer)this.applicationContext.getBean("transformer.OpenOffice");
        ContentTransformer pdfBoxTransformer = (ContentTransformer)this.applicationContext.getBean("transformer.PdfBox");
        if (unoTransformer.getReliability("application/vnd.powerpoint", "application/pdf") == 0.0) {
            this.isAvailable = false;
            return;
        }
        if (pdfBoxTransformer.getReliability("application/pdf", "text/plain") == 0.0) {
            this.isAvailable = false;
            return;
        }
        this.isAvailable = true;
        this.transformer = new ComplexContentTransformer();
        this.transformer.setMimetypeService(this.mimetypeMap);
        ArrayList<ContentTransformer> transformers = new ArrayList<ContentTransformer>(2);
        transformers.add(unoTransformer);
        transformers.add(pdfBoxTransformer);
        this.transformer.setTransformers(transformers);
        List<String> intermediateMimetypes = Collections.singletonList("application/pdf");
        this.transformer.setIntermediateMimetypes(intermediateMimetypes);
    }

    protected ContentTransformer getTransformer(String sourceMimetype, String targetMimetype) {
        return this.transformer;
    }

    public void testReliability() throws Exception {
        if (!this.isAvailable) {
            return;
        }
        double reliability = 0.0;
        reliability = this.transformer.getReliability("application/vnd.powerpoint", "application/pdf");
        ComplexContentTransformerTest.assertEquals((String)"Mimetype should not be supported", (Object)0.0, (Object)reliability);
        reliability = this.transformer.getReliability("application/vnd.powerpoint", "text/plain");
        ComplexContentTransformerTest.assertEquals((String)"Mimetype should be supported", (Object)1.0, (Object)reliability);
    }
}

