/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.transform;

import java.io.File;
import java.util.LinkedList;
import java.util.Map;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.content.filestore.FileContentWriter;
import org.alfresco.repo.content.transform.ContentTransformer;
import org.alfresco.repo.content.transform.ContentTransformerRegistry;
import org.alfresco.service.cmr.repository.ContentIOException;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.util.TempFileProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompoundContentTransformer
implements ContentTransformer {
    private static final Log logger = LogFactory.getLog(CompoundContentTransformer.class);
    private LinkedList<Transformation> chain = new LinkedList();
    private double reliability = 1.0;

    public void addTransformation(String sourceMimetype, String targetMimetype, ContentTransformer transformer) {
        Transformation transformation = new Transformation(transformer, sourceMimetype, targetMimetype);
        this.chain.add(transformation);
        double transformerReliability = transformer.getReliability(sourceMimetype, targetMimetype);
        if (transformerReliability <= 0.0 || transformerReliability > 1.0) {
            throw new AlfrescoRuntimeException("Reliability of transformer must be between 0.0 and 1.0: \n   transformer: " + transformer + "\n" + "   source: " + sourceMimetype + "\n" + "   target: " + targetMimetype + "\n" + "   reliability: " + transformerReliability);
        }
        this.reliability *= transformerReliability;
    }

    @Override
    public double getReliability(String sourceMimetype, String targetMimetype) {
        if (this.chain.size() == 0) {
            return 0.0;
        }
        Transformation first = this.chain.getFirst();
        Transformation last = this.chain.getLast();
        if (!first.getSourceMimetype().equals(sourceMimetype) && last.getTargetMimetype().equals(targetMimetype)) {
            return 0.0;
        }
        return this.reliability;
    }

    @Override
    public long getTransformationTime() {
        long transformationTime = 0L;
        for (Transformation transformation : this.chain) {
            ContentTransformer transformer = transformation.transformer;
            transformationTime += transformer.getTransformationTime();
        }
        return transformationTime;
    }

    @Override
    public void transform(ContentReader reader, ContentWriter writer) throws ContentIOException {
        this.transform(reader, writer, null);
    }

    @Override
    public void transform(ContentReader reader, ContentWriter writer, Map<String, Object> options) throws ContentIOException {
        if (this.chain.size() == 0) {
            throw new AlfrescoRuntimeException("No transformations present in chain");
        }
        String sourceMimetype = reader.getMimetype();
        String targetMimetype = writer.getMimetype();
        Transformation firstTransformation = this.chain.getFirst();
        Transformation lastTransformation = this.chain.getLast();
        if (!firstTransformation.getSourceMimetype().equals(sourceMimetype) && lastTransformation.getTargetMimetype().equals(targetMimetype)) {
            throw new AlfrescoRuntimeException("Attempting to perform unreliable transformation: \n   reader: " + reader + "\n" + "   writer: " + writer);
        }
        ContentReader currentReader = reader;
        ContentWriter currentWriter = null;
        int currentIndex = 0;
        for (Transformation transformation : this.chain) {
            boolean last;
            boolean bl = last = currentIndex == this.chain.size() - 1;
            if (last) {
                currentWriter = writer;
            } else {
                File tempFile = TempFileProvider.createTempFile((String)"transform", (String)".tmp");
                currentWriter = new FileContentWriter(tempFile);
                currentWriter.setMimetype(transformation.getTargetMimetype());
            }
            transformation.execute(currentReader, currentWriter, options);
            if (!currentWriter.isClosed()) {
                throw new AlfrescoRuntimeException("Writer not closed by transformation: \n   transformation: " + transformation + "\n" + "   writer: " + currentWriter);
            }
            if (last) continue;
            currentReader = currentWriter.getReader();
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Executed complex transformation: \n   chain: " + this.chain + "\n" + "   reader: " + reader + "\n" + "   writer: " + writer));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Transformation
    extends ContentTransformerRegistry.TransformationKey {
        private ContentTransformer transformer;

        public Transformation(ContentTransformer transformer, String sourceMimetype, String targetMimetype) {
            super(sourceMimetype, targetMimetype);
            this.transformer = transformer;
        }

        public void execute(ContentReader reader, ContentWriter writer, Map<String, Object> options) throws ContentIOException {
            String sourceMimetype = this.getSourceMimetype();
            String targetMimetype = this.getTargetMimetype();
            if (!sourceMimetype.equals(reader.getMimetype())) {
                throw new AlfrescoRuntimeException("The source mimetype doesn't match the reader's mimetype: \n   source mimetype: " + sourceMimetype + "\n" + "   reader: " + reader);
            }
            if (!targetMimetype.equals(writer.getMimetype())) {
                throw new AlfrescoRuntimeException("The target mimetype doesn't match the writer's mimetype: \n   target mimetype: " + targetMimetype + "\n" + "   writer: " + writer);
            }
            this.transformer.transform(reader, writer, options);
        }
    }
}

