/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.transform;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.content.MimetypeMap;
import org.alfresco.repo.content.transform.ContentTransformer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContentTransformerRegistry {
    private static final Log logger = LogFactory.getLog(ContentTransformerRegistry.class);
    private List<ContentTransformer> transformers;
    private MimetypeMap mimetypeMap;
    private Map<TransformationKey, List<ContentTransformer>> transformationCache;
    private short accessCount;
    private Lock transformationCacheReadLock;
    private Lock transformationCacheWriteLock;

    public ContentTransformerRegistry(MimetypeMap mimetypeMap) {
        Assert.notNull((Object)mimetypeMap, (String)"The MimetypeMap is mandatory");
        this.mimetypeMap = mimetypeMap;
        this.transformers = new ArrayList<ContentTransformer>(10);
        this.transformationCache = new HashMap<TransformationKey, List<ContentTransformer>>(17);
        this.accessCount = 0;
        ReentrantReadWriteLock transformationCacheLock = new ReentrantReadWriteLock();
        this.transformationCacheReadLock = transformationCacheLock.readLock();
        this.transformationCacheWriteLock = transformationCacheLock.writeLock();
    }

    public void addExplicitTransformer(TransformationKey key, ContentTransformer transformer) {
        this.transformationCache.put(key, Collections.singletonList(transformer));
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Registered explicit transformation: \n   key: " + key + "\n" + "   transformer: " + transformer));
        }
    }

    public void addTransformer(ContentTransformer transformer) {
        this.transformers.add(transformer);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Registered general transformer: \n   transformer: " + transformer));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetCache() {
        this.transformationCacheWriteLock.lock();
        try {
            this.transformationCache.clear();
            this.accessCount = 0;
        }
        finally {
            this.transformationCacheWriteLock.unlock();
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Content transformation cache reset");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContentTransformer getTransformer(String sourceMimetype, String targetMimetype) {
        if (!this.mimetypeMap.getMimetypes().contains(sourceMimetype)) {
            throw new AlfrescoRuntimeException("Unknown source mimetype: " + sourceMimetype);
        }
        if (!this.mimetypeMap.getMimetypes().contains(targetMimetype)) {
            throw new AlfrescoRuntimeException("Unknown target mimetype: " + targetMimetype);
        }
        TransformationKey key = new TransformationKey(sourceMimetype, targetMimetype);
        List<ContentTransformer> transformers = null;
        this.transformationCacheReadLock.lock();
        try {
            if (this.transformationCache.containsKey(key)) {
                transformers = this.transformationCache.get(key);
            }
        }
        finally {
            this.transformationCacheReadLock.unlock();
        }
        if (transformers == null) {
            this.transformationCacheWriteLock.lock();
            try {
                transformers = this.findTransformers(sourceMimetype, targetMimetype);
                this.transformationCache.put(key, transformers);
            }
            finally {
                this.transformationCacheWriteLock.unlock();
            }
        }
        long bestTime = -1L;
        ContentTransformer bestTransformer = null;
        for (ContentTransformer transformer : transformers) {
            long transformationTime = transformer.getTransformationTime();
            if (bestTransformer != null && transformationTime >= bestTime) continue;
            bestTransformer = transformer;
            bestTime = transformationTime;
        }
        return bestTransformer;
    }

    private List<ContentTransformer> findTransformers(String sourceMimetype, String targetMimetype) {
        List<ContentTransformer> transformers = this.findDirectTransformers(sourceMimetype, targetMimetype);
        List<ContentTransformer> complexTransformers = this.findComplexTransformer(sourceMimetype, targetMimetype);
        transformers.addAll(complexTransformers);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Searched for transformer: \n   source mimetype: " + sourceMimetype + "\n" + "   target mimetype: " + targetMimetype + "\n" + "   transformers: " + transformers));
        }
        return transformers;
    }

    private List<ContentTransformer> findDirectTransformers(String sourceMimetype, String targetMimetype) {
        double maxReliability = 0.0;
        long leastTime = 100000L;
        ArrayList<ContentTransformer> bestTransformers = new ArrayList<ContentTransformer>(2);
        for (ContentTransformer transformer : this.transformers) {
            double reliability = transformer.getReliability(sourceMimetype, targetMimetype);
            if (reliability <= 0.0 || reliability < maxReliability) continue;
            if (reliability != maxReliability) {
                bestTransformers.clear();
                maxReliability = reliability;
            }
            bestTransformers.add(transformer);
        }
        return bestTransformers;
    }

    private List<ContentTransformer> findComplexTransformer(String sourceMimetype, String targetMimetype) {
        return Collections.emptyList();
    }

    private void buildTransformer(List<ContentTransformer> transformers, double reliability, List<String> touchedMimetypes, String currentMimetype, String targetMimetype) {
        throw new UnsupportedOperationException();
    }

    public static class TransformationKey {
        private final String sourceMimetype;
        private final String targetMimetype;
        private final String key;

        public TransformationKey(String sourceMimetype, String targetMimetype) {
            this.key = sourceMimetype + "_" + targetMimetype;
            this.sourceMimetype = sourceMimetype;
            this.targetMimetype = targetMimetype;
        }

        public String getSourceMimetype() {
            return this.sourceMimetype;
        }

        public String getTargetMimetype() {
            return this.targetMimetype;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof TransformationKey)) {
                return false;
            }
            TransformationKey that = (TransformationKey)obj;
            return this.key.equals(that.key);
        }

        public int hashCode() {
            return this.key.hashCode();
        }
    }
}

