/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.transform;

import java.util.Collections;
import java.util.Map;
import org.alfresco.repo.content.filestore.FileContentReader;
import org.alfresco.repo.content.filestore.FileContentWriter;
import org.alfresco.repo.content.transform.AbstractContentTransformer;
import org.alfresco.repo.content.transform.AbstractContentTransformerTest;
import org.alfresco.repo.content.transform.ContentTransformer;
import org.alfresco.repo.content.transform.ContentTransformerRegistry;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.MimetypeService;
import org.alfresco.util.TempFileProvider;

public class ContentTransformerRegistryTest
extends AbstractContentTransformerTest {
    private static final String A = "text/plain";
    private static final String B = "text/xml";
    private static final String C = "application/msword";
    private static final String D = "text/html";
    private ContentTransformerRegistry registry;
    private ContentTransformerRegistry dummyRegistry;
    private ContentReader reader;
    private ContentWriter writer;

    public void setContentTransformerRegistry(ContentTransformerRegistry registry) {
        this.registry = registry;
    }

    public void onSetUpInTransaction() throws Exception {
        this.reader = new FileContentReader(TempFileProvider.createTempFile((String)this.getName(), (String)".txt"));
        this.reader.setMimetype(A);
        this.writer = new FileContentWriter(TempFileProvider.createTempFile((String)this.getName(), (String)".txt"));
        this.writer.setMimetype(D);
        byte[] bytes = new byte[256];
        for (int i = 0; i < 256; ++i) {
            bytes[i] = (byte)i;
        }
        this.dummyRegistry = new ContentTransformerRegistry(this.mimetypeMap);
        new DummyTransformer(this.mimetypeMap, this.dummyRegistry, A, B, 0.3, 10L);
        new DummyTransformer(this.mimetypeMap, this.dummyRegistry, A, B, 0.6, 10L);
        new DummyTransformer(this.mimetypeMap, this.dummyRegistry, A, C, 0.5, 10L);
        new DummyTransformer(this.mimetypeMap, this.dummyRegistry, A, C, 1.0, 10L);
        new DummyTransformer(this.mimetypeMap, this.dummyRegistry, B, C, 0.2, 10L);
        new DummyTransformer(this.mimetypeMap, this.dummyRegistry, A, D, 1.0, 20L);
        new DummyTransformer(this.mimetypeMap, this.dummyRegistry, A, D, 1.0, 20L);
        new DummyTransformer(this.mimetypeMap, this.dummyRegistry, A, D, 1.0, 10L);
        new DummyTransformer(this.mimetypeMap, this.dummyRegistry, A, D, 1.0, 20L);
        new DummyTransformer(this.mimetypeMap, this.dummyRegistry, A, D, 1.0, 20L);
    }

    public void testSetUp() throws Exception {
        super.testSetUp();
        ContentTransformerRegistryTest.assertNotNull((Object)this.registry);
    }

    protected ContentTransformer getTransformer(String sourceMimetype, String targetMimetype) {
        return this.registry.getTransformer(sourceMimetype, targetMimetype);
    }

    public void testNullRetrieval() throws Exception {
        ContentTransformer transformer = null;
        transformer = this.dummyRegistry.getTransformer(C, B);
        ContentTransformerRegistryTest.assertNull((String)"No transformer expected", (Object)transformer);
        transformer = this.dummyRegistry.getTransformer(C, A);
        ContentTransformerRegistryTest.assertNull((String)"No transformer expected", (Object)transformer);
        transformer = this.dummyRegistry.getTransformer(B, A);
        ContentTransformerRegistryTest.assertNull((String)"No transformer expected", (Object)transformer);
    }

    public void testSimpleRetrieval() throws Exception {
        ContentTransformer transformer = null;
        transformer = this.dummyRegistry.getTransformer(B, C);
        transformer = this.dummyRegistry.getTransformer(B, C);
        ContentTransformerRegistryTest.assertNotNull((String)"No transformer found", (Object)transformer);
        ContentTransformerRegistryTest.assertEquals((String)"Incorrect reliability", (Object)0.2, (Object)transformer.getReliability(B, C));
        ContentTransformerRegistryTest.assertEquals((String)"Incorrect reliability", (Object)0.0, (Object)transformer.getReliability(C, B));
    }

    public void testPerformanceRetrieval() throws Exception {
        ContentTransformer transformer1 = this.dummyRegistry.getTransformer(A, D);
        ContentTransformerRegistryTest.assertEquals((String)"Incorrect reliability", (Object)1.0, (Object)transformer1.getReliability(A, D));
        ContentTransformerRegistryTest.assertEquals((String)"Incorrect reliability", (Object)0.0, (Object)transformer1.getReliability(D, A));
        ContentTransformerRegistryTest.assertEquals((String)"Incorrect transformation time", (long)10L, (long)transformer1.getTransformationTime());
    }

    public void testScoredRetrieval() throws Exception {
        ContentTransformer transformer = null;
        transformer = this.dummyRegistry.getTransformer(A, B);
        ContentTransformerRegistryTest.assertNotNull((String)"No transformer found", (Object)transformer);
        ContentTransformerRegistryTest.assertEquals((String)"Incorrect reliability", (Object)0.6, (Object)transformer.getReliability(A, B));
        ContentTransformerRegistryTest.assertEquals((String)"Incorrect reliability", (Object)0.0, (Object)transformer.getReliability(B, A));
        transformer = this.dummyRegistry.getTransformer(A, C);
        ContentTransformerRegistryTest.assertNotNull((String)"No transformer found", (Object)transformer);
        ContentTransformerRegistryTest.assertEquals((String)"Incorrect reliability", (Object)1.0, (Object)transformer.getReliability(A, C));
        ContentTransformerRegistryTest.assertEquals((String)"Incorrect reliability", (Object)0.0, (Object)transformer.getReliability(C, A));
    }

    public void testExplicitTransformation() {
        DummyTransformer dummyTransformer = new DummyTransformer(this.mimetypeMap, this.dummyRegistry, "application/x-shockwave-flash", "application/vnd.excel", 1.0, 12345L);
        ContentTransformerRegistry.TransformationKey key = new ContentTransformerRegistry.TransformationKey("application/x-shockwave-flash", "application/vnd.excel");
        dummyTransformer.setExplicitTransformations(Collections.singletonList(key));
        dummyTransformer.register();
        ContentTransformer checkTransformer = this.dummyRegistry.getTransformer("application/x-shockwave-flash", "application/vnd.excel");
        ContentTransformerRegistryTest.assertNotNull((String)"No explicit transformer found", (Object)checkTransformer);
        ContentTransformerRegistryTest.assertTrue((String)"Expected explicit transformer", (dummyTransformer == checkTransformer ? 1 : 0) != 0);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DummyTransformer
    extends AbstractContentTransformer {
        private String sourceMimetype;
        private String targetMimetype;
        private double reliability;
        private long transformationTime;

        public DummyTransformer(MimetypeService mimetypeService, ContentTransformerRegistry registry, String sourceMimetype, String targetMimetype, double reliability, long transformationTime) {
            super.setMimetypeService(mimetypeService);
            super.setRegistry(registry);
            this.sourceMimetype = sourceMimetype;
            this.targetMimetype = targetMimetype;
            this.reliability = reliability;
            this.transformationTime = transformationTime;
            this.register();
        }

        @Override
        public double getReliability(String sourceMimetype, String targetMimetype) {
            if (this.sourceMimetype.equals(sourceMimetype) && this.targetMimetype.equals(targetMimetype)) {
                return this.reliability;
            }
            return 0.0;
        }

        @Override
        public void transformInternal(ContentReader reader, ContentWriter writer, Map<String, Object> options) throws Exception {
            super.recordTime(this.transformationTime);
        }

        @Override
        public synchronized long getTransformationTime() {
            return this.transformationTime;
        }
    }
}

