/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.transform;

import java.io.File;
import java.util.Map;
import org.alfresco.repo.content.transform.AbstractContentTransformer;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.util.TempFileProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.htmlparser.beans.StringBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlParserContentTransformer
extends AbstractContentTransformer {
    private static final Log logger = LogFactory.getLog(HtmlParserContentTransformer.class);

    @Override
    public double getReliability(String sourceMimetype, String targetMimetype) {
        if (!"text/html".equals(sourceMimetype) || !"text/plain".equals(targetMimetype)) {
            return 0.0;
        }
        return 1.0;
    }

    @Override
    public void transformInternal(ContentReader reader, ContentWriter writer, Map<String, Object> options) throws Exception {
        File htmlFile = TempFileProvider.createTempFile((String)"HtmlParserContentTransformer_", (String)".html");
        reader.getContent(htmlFile);
        StringBean extractor = new StringBean();
        extractor.setCollapse(false);
        extractor.setLinks(false);
        extractor.setReplaceNonBreakingSpaces(false);
        extractor.setURL(htmlFile.getAbsolutePath());
        String text = extractor.getStrings();
        writer.putContent(text);
    }
}

