/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.transform;

import java.io.InputStream;
import java.util.Map;
import org.alfresco.repo.content.transform.AbstractContentTransformer;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.pdfbox.pdmodel.PDDocument;
import org.pdfbox.util.PDFTextStripper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PdfBoxContentTransformer
extends AbstractContentTransformer {
    @Override
    public double getReliability(String sourceMimetype, String targetMimetype) {
        if (!"application/pdf".equals(sourceMimetype) || !"text/plain".equals(targetMimetype)) {
            return 0.0;
        }
        return 1.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void transformInternal(ContentReader reader, ContentWriter writer, Map<String, Object> options) throws Exception {
        PDDocument pdf = null;
        InputStream is = null;
        try {
            is = reader.getContentInputStream();
            pdf = PDDocument.load((InputStream)is);
            PDFTextStripper stripper = new PDFTextStripper();
            String text = stripper.getText(pdf);
            writer.putContent(text);
        }
        finally {
            if (pdf != null) {
                try {
                    pdf.close();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

