/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.transform;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.alfresco.repo.content.transform.AbstractContentTransformer;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PoiHssfContentTransformer
extends AbstractContentTransformer {
    private static final String LINE_BREAK = "\r\n";

    @Override
    public double getReliability(String sourceMimetype, String targetMimetype) {
        if (!"application/vnd.excel".equals(sourceMimetype) || !"text/plain".equals(targetMimetype)) {
            return 0.0;
        }
        return 1.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void transformInternal(ContentReader reader, ContentWriter writer, Map<String, Object> options) throws Exception {
        InputStream is = reader.getContentInputStream();
        OutputStream os = writer.getContentOutputStream();
        String encoding = writer.getEncoding();
        try {
            HSSFWorkbook workbook = new HSSFWorkbook(is);
            int sheetCount = workbook.getNumberOfSheets();
            for (int i = 0; i < sheetCount; ++i) {
                HSSFSheet sheet = workbook.getSheetAt(i);
                String sheetName = workbook.getSheetName(i);
                this.writeSheet(os, sheet, encoding);
                PoiHssfContentTransformer.writeString(os, encoding, LINE_BREAK, false);
                PoiHssfContentTransformer.writeString(os, encoding, "End of sheet: " + sheetName, true);
                PoiHssfContentTransformer.writeString(os, encoding, LINE_BREAK, false);
                PoiHssfContentTransformer.writeString(os, encoding, LINE_BREAK, false);
            }
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Throwable e) {}
            }
            if (os != null) {
                try {
                    os.close();
                }
                catch (Throwable e) {}
            }
        }
    }

    private void writeSheet(OutputStream os, HSSFSheet sheet, String encoding) throws Exception {
        int rows = sheet.getLastRowNum();
        for (int i = 0; i <= rows; ++i) {
            HSSFRow row = sheet.getRow(i);
            if (row != null) {
                this.writeRow(os, row, encoding);
            }
            if (i >= rows) continue;
            PoiHssfContentTransformer.writeString(os, encoding, LINE_BREAK, false);
        }
    }

    private void writeRow(OutputStream os, HSSFRow row, String encoding) throws Exception {
        short i;
        short firstCellNum = row.getFirstCellNum();
        short lastCellNum = row.getLastCellNum();
        for (i = 0; i < firstCellNum; i = (short)(i + 1)) {
            PoiHssfContentTransformer.writeString(os, encoding, ",", false);
        }
        for (i = 0; i <= lastCellNum; i = (short)(i + 1)) {
            HSSFCell cell = row.getCell(i);
            if (cell != null) {
                StringBuilder sb = new StringBuilder(10);
                switch (cell.getCellType()) {
                    case 3: {
                        break;
                    }
                    case 4: {
                        sb.append(cell.getBooleanCellValue());
                        break;
                    }
                    case 5: {
                        sb.append("ERROR");
                        break;
                    }
                    case 2: {
                        double dataNumber = cell.getNumericCellValue();
                        if (Double.isNaN(dataNumber)) {
                            sb.append(cell.getStringCellValue());
                            break;
                        }
                        sb.append(dataNumber);
                        break;
                    }
                    case 0: {
                        sb.append(cell.getNumericCellValue());
                        break;
                    }
                    case 1: {
                        sb.append(cell.getStringCellValue());
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unknown HSSF cell type: " + cell);
                    }
                }
                String data = sb.toString();
                PoiHssfContentTransformer.writeString(os, encoding, data, true);
            }
            if (i >= lastCellNum) continue;
            PoiHssfContentTransformer.writeString(os, encoding, ",", false);
        }
    }

    public static void writeString(OutputStream os, String encoding, String value, boolean isData) throws Exception {
        if (value == null) {
            return;
        }
        int dataLength = value.length();
        if (dataLength == 0) {
            return;
        }
        StringBuilder sb = new StringBuilder(dataLength + 5);
        for (int i = 0; i < dataLength; ++i) {
            char currentChar = value.charAt(i);
            if (currentChar == '\"') {
                sb.append("\"");
            }
            sb.append(currentChar);
        }
        if (isData) {
            sb.insert(0, "\"");
            sb.append("\"");
        }
        value = sb.toString();
        byte[] bytes = null;
        bytes = encoding == null ? value.getBytes() : value.getBytes(encoding);
        os.write(bytes);
    }
}

