/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.transform;

import java.io.File;
import java.io.InputStream;
import org.alfresco.repo.content.filestore.FileContentWriter;
import org.alfresco.repo.content.transform.AbstractContentTransformerTest;
import org.alfresco.repo.content.transform.ContentTransformer;
import org.alfresco.repo.content.transform.PoiHssfContentTransformer;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.util.TempFileProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PoiHssfContentTransformerTest
extends AbstractContentTransformerTest {
    private static final Log logger = LogFactory.getLog(PoiHssfContentTransformerTest.class);
    private ContentTransformer transformer;

    public void onSetUpInTransaction() throws Exception {
        this.transformer = new PoiHssfContentTransformer();
    }

    protected ContentTransformer getTransformer(String sourceMimetype, String targetMimetype) {
        return this.transformer;
    }

    public void testReliability() throws Exception {
        double reliability = 0.0;
        reliability = this.transformer.getReliability("text/plain", "application/vnd.excel");
        PoiHssfContentTransformerTest.assertEquals((String)"Mimetype should not be supported", (Object)0.0, (Object)reliability);
        reliability = this.transformer.getReliability("application/vnd.excel", "text/plain");
        PoiHssfContentTransformerTest.assertEquals((String)"Mimetype should be supported", (Object)1.0, (Object)reliability);
    }

    public void xtestBugFixAR114() throws Exception {
        File tempFile = TempFileProvider.createTempFile((String)(((Object)((Object)this)).getClass().getSimpleName() + "_" + this.getName() + "_"), (String)".xls");
        FileContentWriter writer = new FileContentWriter(tempFile);
        writer.setMimetype("application/vnd.excel");
        InputStream is = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("Plan270904b.xls");
        PoiHssfContentTransformerTest.assertNotNull((Object)"Test resource not found: Plan270904b.xls");
        writer.putContent(is);
        ContentReader reader = writer.getReader();
        tempFile = TempFileProvider.createTempFile((String)(((Object)((Object)this)).getClass().getSimpleName() + "_" + this.getName() + "_"), (String)".txt");
        writer = new FileContentWriter(tempFile);
        writer.setMimetype("text/plain");
        this.transformer.transform(reader, writer);
    }
}

